/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.meta;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.EWildcardBoundMode;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.meta.CodeModelBuildingException;
import com.helger.jcodemodel.meta.DecidedErrorTypesModelsAdapter;
import com.helger.jcodemodel.meta.ErrorTypeFound;
import com.helger.jcodemodel.meta.ErrorTypePolicy;
import com.helger.jcodemodel.meta.RuntimeCodeModelBuildingException;
import com.helger.jcodemodel.meta.RuntimeErrorTypeFound;
import com.helger.jcodemodel.meta.TypeEnvironment;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor6;

class TypeMirrorToJTypeVisitor
extends AbstractTypeVisitor6<AbstractJType, Void> {
    private final ErrorTypePolicy m_aErrorTypePolicy;
    private final TypeEnvironment m_aEnvironment;
    private final JCodeModel m_aCodeModel;
    private final DecidedErrorTypesModelsAdapter m_aModelsAdapter;

    public TypeMirrorToJTypeVisitor(JCodeModel jCodeModel, DecidedErrorTypesModelsAdapter decidedErrorTypesModelsAdapter, ErrorTypePolicy errorTypePolicy, TypeEnvironment typeEnvironment) {
        this.m_aCodeModel = jCodeModel;
        this.m_aModelsAdapter = decidedErrorTypesModelsAdapter;
        this.m_aErrorTypePolicy = errorTypePolicy;
        this.m_aEnvironment = typeEnvironment;
    }

    @Override
    public AbstractJType visitPrimitive(PrimitiveType primitiveType, Void void_) {
        switch (primitiveType.getKind()) {
            case BOOLEAN: {
                return this.m_aCodeModel.BOOLEAN;
            }
            case BYTE: {
                return this.m_aCodeModel.BYTE;
            }
            case CHAR: {
                return this.m_aCodeModel.CHAR;
            }
            case INT: {
                return this.m_aCodeModel.INT;
            }
            case LONG: {
                return this.m_aCodeModel.LONG;
            }
            case FLOAT: {
                return this.m_aCodeModel.FLOAT;
            }
            case DOUBLE: {
                return this.m_aCodeModel.DOUBLE;
            }
            case SHORT: {
                return this.m_aCodeModel.SHORT;
            }
        }
        throw new IllegalArgumentException("Unrecognized primitive " + (Object)((Object)primitiveType.getKind()));
    }

    @Override
    public AbstractJType visitNull(NullType nullType, Void void_) {
        throw new IllegalArgumentException("null can't be JClass.");
    }

    @Override
    public AbstractJType visitArray(ArrayType arrayType, Void void_) {
        try {
            AbstractJType abstractJType = this.m_aModelsAdapter.toJType(arrayType.getComponentType(), this.m_aEnvironment);
            return abstractJType.array();
        }
        catch (CodeModelBuildingException codeModelBuildingException) {
            throw new RuntimeCodeModelBuildingException(codeModelBuildingException);
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }

    @Override
    public AbstractJType visitDeclared(DeclaredType declaredType, Void void_) {
        try {
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            AbstractJClass abstractJClass = this.m_aModelsAdapter.ref(typeElement);
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                abstractJClass = abstractJClass.narrow(this.m_aModelsAdapter.toJType(typeMirror, this.m_aEnvironment));
            }
            return abstractJClass;
        }
        catch (CodeModelBuildingException codeModelBuildingException) {
            throw new RuntimeCodeModelBuildingException(codeModelBuildingException);
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }

    @Override
    public AbstractJType visitError(ErrorType errorType, Void void_) {
        String string = errorType.asElement().getSimpleName().toString();
        String string2 = this.m_aEnvironment.packageName() + "." + string;
        JDefinedClass jDefinedClass = this.m_aCodeModel._getClass(string2);
        if (jDefinedClass != null) {
            List<? extends TypeMirror> list = errorType.getTypeArguments();
            if (list.isEmpty()) {
                return jDefinedClass;
            }
            ArrayList<AbstractJClass> arrayList = new ArrayList<AbstractJClass>(list.size());
            for (TypeMirror typeMirror : list) {
                try {
                    arrayList.add((AbstractJClass)this.m_aModelsAdapter.toJType(typeMirror, this.m_aEnvironment));
                }
                catch (CodeModelBuildingException codeModelBuildingException) {
                    throw new RuntimeCodeModelBuildingException(codeModelBuildingException);
                }
                catch (ErrorTypeFound errorTypeFound) {
                    throw new RuntimeErrorTypeFound(errorTypeFound);
                }
            }
            return jDefinedClass.narrow(arrayList);
        }
        if (this.m_aErrorTypePolicy.action() == ErrorTypePolicy.EAction.CREATE_ERROR_TYPE) {
            return this.m_aCodeModel.errorClass(string + " in annotated source code", string.equals("<any>") ? null : string);
        }
        try {
            throw new ErrorTypeFound(string + " in annotated source code");
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }

    @Override
    public AbstractJType visitTypeVariable(TypeVariable typeVariable, Void void_) {
        String string = typeVariable.asElement().getSimpleName().toString();
        AbstractJType abstractJType = this.m_aEnvironment.get(string);
        if (abstractJType != null) {
            return abstractJType;
        }
        if (this.m_aErrorTypePolicy.action() == ErrorTypePolicy.EAction.CREATE_ERROR_TYPE) {
            return this.m_aCodeModel.errorClass("Missing type-variable " + string + " in annotated source code");
        }
        try {
            throw new ErrorTypeFound("Missing type-variable " + string + " in annotated source code");
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }

    @Override
    public AbstractJType visitWildcard(WildcardType wildcardType, Void void_) {
        try {
            TypeMirror typeMirror = wildcardType.getExtendsBound();
            if (typeMirror != null) {
                AbstractJClass abstractJClass = (AbstractJClass)this.m_aModelsAdapter.toJType(typeMirror, this.m_aEnvironment);
                return abstractJClass.wildcard(EWildcardBoundMode.EXTENDS);
            }
            TypeMirror typeMirror2 = wildcardType.getSuperBound();
            if (typeMirror2 != null) {
                AbstractJClass abstractJClass = (AbstractJClass)this.m_aModelsAdapter.toJType(typeMirror2, this.m_aEnvironment);
                return abstractJClass.wildcard(EWildcardBoundMode.SUPER);
            }
            return this.m_aCodeModel.wildcard();
        }
        catch (CodeModelBuildingException codeModelBuildingException) {
            throw new RuntimeCodeModelBuildingException(codeModelBuildingException);
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }

    @Override
    public AbstractJType visitExecutable(ExecutableType executableType, Void void_) {
        throw new IllegalArgumentException("executable can't be JClass.");
    }

    @Override
    public AbstractJType visitNoType(NoType noType, Void void_) {
        if (this.m_aErrorTypePolicy.action() == ErrorTypePolicy.EAction.CREATE_ERROR_TYPE) {
            return this.m_aCodeModel.errorClass("'no type' in annotated source code");
        }
        try {
            throw new ErrorTypeFound("'no type' in annotated source code");
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }

    @Override
    public AbstractJType visitUnknown(TypeMirror typeMirror, Void void_) {
        if (this.m_aErrorTypePolicy.action() == ErrorTypePolicy.EAction.CREATE_ERROR_TYPE) {
            return this.m_aCodeModel.errorClass("'unknown type' in annotated source code");
        }
        try {
            throw new ErrorTypeFound("'unknown type' in annotated source code");
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }
}

