/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.meta;

import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.meta.CodeModelBuildingException;
import com.helger.jcodemodel.meta.DecidedErrorTypesModelsAdapter;
import com.helger.jcodemodel.meta.ErrorTypeFound;
import com.helger.jcodemodel.meta.ErrorTypePolicy;
import javax.annotation.Nonnull;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class JCodeModelJavaxLangModelAdapter {
    private final JCodeModel m_aCodeModel;
    private final Elements m_aElementUtils;

    public JCodeModelJavaxLangModelAdapter(@Nonnull JCodeModel jCodeModel, @Nonnull Elements elements) {
        this.m_aCodeModel = jCodeModel;
        this.m_aElementUtils = elements;
    }

    @Nonnull
    public JDefinedClass getClass(@Nonnull TypeElement typeElement) throws ErrorTypeFound, CodeModelBuildingException {
        ErrorTypePolicy errorTypePolicy = new ErrorTypePolicy(ErrorTypePolicy.EAction.THROW_EXCEPTION, true);
        return this.getClass(typeElement, errorTypePolicy);
    }

    @Nonnull
    public JDefinedClass getClassWithErrorTypes(@Nonnull TypeElement typeElement) throws CodeModelBuildingException {
        ErrorTypePolicy errorTypePolicy = new ErrorTypePolicy(ErrorTypePolicy.EAction.CREATE_ERROR_TYPE, true);
        try {
            return this.getClass(typeElement, errorTypePolicy);
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeException("ErrorTypeFound exception is disabled and shouldn't be thrown here", errorTypeFound);
        }
    }

    @Nonnull
    public JDefinedClass getClass(@Nonnull TypeElement typeElement, @Nonnull ErrorTypePolicy errorTypePolicy) throws ErrorTypeFound, CodeModelBuildingException {
        DecidedErrorTypesModelsAdapter decidedErrorTypesModelsAdapter = new DecidedErrorTypesModelsAdapter(this.m_aCodeModel, this.m_aElementUtils, errorTypePolicy);
        return decidedErrorTypesModelsAdapter.getClass(typeElement);
    }
}

