/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJGenerifiableImpl;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.ChangeInV4;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJDocCommentable;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JDocComment;
import com.helger.jcodemodel.JMods;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.util.ClassNameComparator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JMethod
extends AbstractJGenerifiableImpl
implements IJAnnotatable,
IJDocCommentable {
    private final JMods m_aMods;
    private AbstractJType m_aReturnType;
    private String m_sName;
    private final List<JVar> m_aParams = new ArrayList<JVar>();
    private final Set<AbstractJClass> m_aThrows = new TreeSet<AbstractJClass>(ClassNameComparator.getInstance());
    private JBlock m_aBody;
    private final JDefinedClass m_aOwningClass;
    private JDocComment m_aJDoc;
    private JVar m_aVarParam;
    private List<JAnnotationUse> m_aAnnotations;
    private IJExpression m_aDefaultValue;

    protected JMethod(@Nonnull JDefinedClass jDefinedClass, int n, @Nonnull AbstractJType abstractJType, @Nonnull String string) {
        JCValueEnforcer.notNull(jDefinedClass, "OwningClass");
        JCValueEnforcer.notNull(abstractJType, "ReturnType");
        JCValueEnforcer.notEmpty(string, "Name");
        this.m_aMods = JMods.forMethod(n);
        this.m_aReturnType = abstractJType;
        this.m_sName = string;
        this.m_aOwningClass = jDefinedClass;
    }

    protected JMethod(int n, @Nonnull JDefinedClass jDefinedClass) {
        JCValueEnforcer.notNull(jDefinedClass, "Class");
        this.m_aMods = JMods.forMethod(n);
        this.m_aReturnType = null;
        this.m_sName = jDefinedClass.name();
        this.m_aOwningClass = jDefinedClass;
    }

    public boolean isConstructor() {
        return this.m_aReturnType == null;
    }

    @Nonnull
    public Set<AbstractJClass> throwsMutable() {
        return this.m_aThrows;
    }

    @Nonnull
    public Collection<AbstractJClass> getThrows() {
        return Collections.unmodifiableSet(this.throwsMutable());
    }

    @Nonnull
    public JMethod _throws(@Nonnull AbstractJClass abstractJClass) {
        this.m_aThrows.add(abstractJClass);
        return this;
    }

    @Nonnull
    public JMethod _throws(@Nonnull Class<? extends Throwable> clazz) {
        return this._throws(this.m_aOwningClass.owner().ref(clazz));
    }

    @Nonnull
    public List<JVar> paramsMutable() {
        return this.m_aParams;
    }

    @Nonnull
    public List<JVar> params() {
        return Collections.unmodifiableList(this.paramsMutable());
    }

    @Nonnull
    public JVar paramAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.m_aParams.get(n);
    }

    @Nonnull
    public JVar param(int n, @Nonnull AbstractJType abstractJType, @Nonnull String string) {
        JVar jVar = new JVar(JMods.forVar(n), abstractJType, string, null);
        this.m_aParams.add(jVar);
        return jVar;
    }

    @Nonnull
    public JVar param(@Nonnull AbstractJType abstractJType, @Nonnull String string) {
        return this.param(0, abstractJType, string);
    }

    @Nonnull
    public JVar param(int n, @Nonnull Class<?> clazz, @Nonnull String string) {
        return this.param(n, this.m_aOwningClass.owner()._ref(clazz), string);
    }

    @Nonnull
    public JVar param(@Nonnull Class<?> clazz, @Nonnull String string) {
        return this.param(this.m_aOwningClass.owner()._ref(clazz), string);
    }

    @Nonnull
    public JVar varParam(@Nonnull Class<?> clazz, @Nonnull String string) {
        return this.varParam(this.m_aOwningClass.owner()._ref(clazz), string);
    }

    @Nonnull
    public JVar varParam(@Nonnull AbstractJType abstractJType, @Nonnull String string) {
        return this.varParam(0, abstractJType, string);
    }

    @Nonnull
    public JVar varParam(int n, @Nonnull Class<?> clazz, @Nonnull String string) {
        return this.varParam(n, this.m_aOwningClass.owner()._ref(clazz), string);
    }

    @Nonnull
    public JVar varParam(int n, @Nonnull AbstractJType abstractJType, @Nonnull String string) {
        JCValueEnforcer.isFalse(this.hasVarArgs(), "Cannot have two varargs in a method,\nCheck if varParam method of JMethod is invoked more than once");
        this.m_aVarParam = new JVar(JMods.forVar(n), abstractJType.array(), string, null);
        return this.m_aVarParam;
    }

    @Nullable
    public JVar varParam() {
        return this.m_aVarParam;
    }

    public boolean hasVarArgs() {
        return this.m_aVarParam != null;
    }

    @Nullable
    public AbstractJType listVarParamType() {
        return this.m_aVarParam != null ? this.m_aVarParam.type() : null;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull AbstractJClass abstractJClass) {
        if (this.m_aAnnotations == null) {
            this.m_aAnnotations = new ArrayList<JAnnotationUse>();
        }
        JAnnotationUse jAnnotationUse = new JAnnotationUse(abstractJClass);
        this.m_aAnnotations.add(jAnnotationUse);
        return jAnnotationUse;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull Class<? extends Annotation> clazz) {
        return this.annotate(this.owner().ref(clazz));
    }

    @Nonnull
    public List<JAnnotationUse> annotationsMutable() {
        if (this.m_aAnnotations == null) {
            return Collections.emptyList();
        }
        return this.m_aAnnotations;
    }

    @Override
    @Nonnull
    public Collection<JAnnotationUse> annotations() {
        return Collections.unmodifiableList(this.annotationsMutable());
    }

    public String name() {
        return this.m_sName;
    }

    public void name(@Nonnull String string) {
        JCValueEnforcer.notEmpty(string, "Name");
        this.m_sName = string;
    }

    @Nullable
    public AbstractJType type() {
        return this.m_aReturnType;
    }

    public void type(@Nullable AbstractJType abstractJType) {
        this.m_aReturnType = abstractJType;
    }

    @Nonnull
    public AbstractJType[] listParamTypes() {
        AbstractJType[] abstractJTypeArray = new AbstractJType[this.m_aParams.size()];
        for (int i = 0; i < abstractJTypeArray.length; ++i) {
            abstractJTypeArray[i] = this.m_aParams.get(i).type();
        }
        return abstractJTypeArray;
    }

    @Nonnull
    public JVar[] listParams() {
        return this.m_aParams.toArray(new JVar[this.m_aParams.size()]);
    }

    @Nullable
    @Deprecated
    @ChangeInV4
    public JVar listVarParam() {
        return this.varParam();
    }

    public boolean hasSignature(@Nonnull AbstractJType[] abstractJTypeArray) {
        JVar[] jVarArray = this.listParams();
        if (jVarArray.length != abstractJTypeArray.length) {
            return false;
        }
        for (int i = 0; i < jVarArray.length; ++i) {
            if (jVarArray[i].type().equals(abstractJTypeArray[i])) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public JBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JBlock();
        }
        return this.m_aBody;
    }

    public void declareDefaultValue(@Nullable IJExpression iJExpression) {
        this.m_aDefaultValue = iJExpression;
    }

    @Override
    @Nonnull
    public JDocComment javadoc() {
        if (this.m_aJDoc == null) {
            this.m_aJDoc = new JDocComment(this.owner());
        }
        return this.m_aJDoc;
    }

    @Override
    public void declare(@Nonnull IJFormatter iJFormatter) {
        if (this.m_aJDoc != null) {
            iJFormatter.generable(this.m_aJDoc);
        }
        if (this.m_aAnnotations != null) {
            for (JAnnotationUse jAnnotationUse : this.m_aAnnotations) {
                iJFormatter.generable(jAnnotationUse).newline();
            }
        }
        iJFormatter.generable(this.m_aMods);
        super.declare(iJFormatter);
        if (!this.isConstructor()) {
            iJFormatter.generable(this.m_aReturnType);
        }
        iJFormatter.id(this.m_sName).print('(').indent();
        boolean bl = true;
        boolean bl2 = this.m_aParams.size() + (this.hasVarArgs() ? 1 : 0) > 3;
        for (IJGenerable iJGenerable : this.m_aParams) {
            if (bl) {
                bl = false;
            } else {
                iJFormatter.print(',');
                if (bl2) {
                    iJFormatter.newline();
                }
            }
            iJFormatter.var((JVar)iJGenerable);
        }
        if (this.hasVarArgs()) {
            if (!bl) {
                iJFormatter.print(',');
                if (bl2) {
                    iJFormatter.newline();
                }
            }
            for (IJGenerable iJGenerable : this.m_aVarParam.annotations()) {
                iJFormatter.generable(iJGenerable).print(' ');
            }
            iJFormatter.generable(this.m_aVarParam.mods()).generable(this.m_aVarParam.type().elementType()).print("... ").id(this.m_aVarParam.name());
        }
        iJFormatter.outdent().print(')');
        if (!this.m_aThrows.isEmpty()) {
            iJFormatter.newline().indent().print("throws").generable(this.m_aThrows).newline().outdent();
        }
        if (this.m_aDefaultValue != null) {
            iJFormatter.print("default ");
            iJFormatter.generable(this.m_aDefaultValue);
        }
        if (this.m_aBody != null) {
            iJFormatter.statement(this.m_aBody);
        } else {
            boolean bl3;
            boolean bl4 = bl3 = this.m_aOwningClass.isInterface() && !this.m_aMods.isDefault() || this.m_aOwningClass.isAnnotationTypeDeclaration() || this.m_aMods.isAbstract() || this.m_aMods.isNative();
            if (bl3) {
                iJFormatter.print(';').newline();
            } else {
                iJFormatter.statement(new JBlock());
            }
        }
    }

    @Nonnull
    public JMods mods() {
        return this.m_aMods;
    }

    @Nonnull
    public JDefinedClass owningClass() {
        return this.m_aOwningClass;
    }

    @Override
    @Nonnull
    public JCodeModel owner() {
        return this.m_aOwningClass.owner();
    }
}

