/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJObject;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAssignment;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JMods;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JForLoop
implements IJStatement {
    private final List<IJObject> m_aInitExprs = new ArrayList<IJObject>();
    private IJExpression m_aTestExpr;
    private final List<IJExpression> m_aUpdateExprs = new ArrayList<IJExpression>();
    private JBlock m_aBody;

    @Nonnull
    public JVar init(int n, @Nonnull AbstractJType abstractJType, @Nonnull String string, @Nullable IJExpression iJExpression) {
        JVar jVar = new JVar(JMods.forVar(n), abstractJType, string, iJExpression);
        this.m_aInitExprs.add(jVar);
        return jVar;
    }

    @Nonnull
    public JVar init(@Nonnull AbstractJType abstractJType, @Nonnull String string, @Nullable IJExpression iJExpression) {
        return this.init(0, abstractJType, string, iJExpression);
    }

    public void init(@Nonnull JVar jVar, @Nonnull IJExpression iJExpression) {
        JAssignment jAssignment = JExpr.assign(jVar, iJExpression);
        this.m_aInitExprs.add(jAssignment);
    }

    @Nonnull
    public List<IJObject> initsMutable() {
        return this.m_aInitExprs;
    }

    @Nonnull
    public List<IJObject> inits() {
        return Collections.unmodifiableList(this.initsMutable());
    }

    public void test(@Nullable IJExpression iJExpression) {
        this.m_aTestExpr = iJExpression;
    }

    @Nullable
    public IJExpression test() {
        return this.m_aTestExpr;
    }

    public void update(@Nonnull IJExpression iJExpression) {
        JCValueEnforcer.notNull(iJExpression, "Update");
        this.m_aUpdateExprs.add(iJExpression);
    }

    @Nonnull
    public List<IJExpression> updatesMutable() {
        return this.m_aUpdateExprs;
    }

    @Nonnull
    public List<IJExpression> updates() {
        return Collections.unmodifiableList(this.updatesMutable());
    }

    @Nonnull
    public JBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JBlock();
        }
        return this.m_aBody;
    }

    @Override
    public void state(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.print("for (");
        boolean bl = true;
        for (IJObject iJObject : this.m_aInitExprs) {
            if (!bl) {
                iJFormatter.print(',');
            }
            if (iJObject instanceof JVar) {
                iJFormatter.var((JVar)iJObject);
            } else {
                iJFormatter.generable((IJExpression)iJObject);
            }
            bl = false;
        }
        iJFormatter.print(';').generable(this.m_aTestExpr).print(';').generable(this.m_aUpdateExprs).print(')');
        if (this.m_aBody != null) {
            iJFormatter.generable(this.m_aBody).newline();
        } else {
            iJFormatter.print(';').newline();
        }
    }
}

