/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JOp;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public class JDoLoop
implements IJStatement {
    private final IJExpression m_aTest;
    private JBlock m_aBody;

    public JDoLoop(@Nonnull IJExpression iJExpression) {
        this.m_aTest = JCValueEnforcer.notNull(iJExpression, "Test");
    }

    @Nonnull
    public IJExpression test() {
        return this.m_aTest;
    }

    @Nonnull
    public JBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JBlock();
        }
        return this.m_aBody;
    }

    @Override
    public void state(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.print("do");
        if (this.m_aBody != null) {
            iJFormatter.generable(this.m_aBody);
        } else {
            iJFormatter.print("{ }");
        }
        if (JOp.hasTopOp(this.m_aTest)) {
            iJFormatter.print("while ").generable(this.m_aTest);
        } else {
            iJFormatter.print("while (").generable(this.m_aTest).print(')');
        }
        iJFormatter.print(';').newline();
    }
}

