/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import javax.annotation.Nonnull;

public class JAtomFloat
implements IJExpression {
    public static final String JAVA_LANG_FLOAT_NEGATIVE_INFINITY = "java.lang.Float.NEGATIVE_INFINITY";
    public static final String JAVA_LANG_FLOAT_POSITIVE_INFINITY = "java.lang.Float.POSITIVE_INFINITY";
    public static final String JAVA_LANG_FLOAT_NAN = "java.lang.Float.NaN";
    public static final String SUFFIX_FLOAT = "F";
    private final float m_fWhat;

    protected JAtomFloat(float f) {
        this.m_fWhat = f;
    }

    public float what() {
        return this.m_fWhat;
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        if (this.m_fWhat == Float.NEGATIVE_INFINITY) {
            iJFormatter.print(JAVA_LANG_FLOAT_NEGATIVE_INFINITY);
        } else if (this.m_fWhat == Float.POSITIVE_INFINITY) {
            iJFormatter.print(JAVA_LANG_FLOAT_POSITIVE_INFINITY);
        } else if (Float.isNaN(this.m_fWhat)) {
            iJFormatter.print(JAVA_LANG_FLOAT_NAN);
        } else {
            iJFormatter.print(Float.toString(this.m_fWhat) + SUFFIX_FLOAT);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JAtomFloat jAtomFloat = (JAtomFloat)object;
        return JCEqualsHelper.isEqual(this.m_fWhat, jAtomFloat.m_fWhat);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, Float.valueOf(this.m_fWhat));
    }
}

