/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJExpressionStatement;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import javax.annotation.Nonnull;

public class JAssignment
implements IJExpressionStatement {
    private final IJAssignmentTarget m_aLhs;
    private final String m_sOperator;
    private final IJExpression m_aRhs;

    protected JAssignment(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        this(iJAssignmentTarget, iJExpression, "");
    }

    protected JAssignment(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression, @Nonnull String string) {
        this.m_aLhs = iJAssignmentTarget;
        this.m_aRhs = iJExpression;
        this.m_sOperator = string;
    }

    @Nonnull
    public IJAssignmentTarget lhs() {
        return this.m_aLhs;
    }

    @Nonnull
    public IJExpression rhs() {
        return this.m_aRhs;
    }

    @Nonnull
    public String op() {
        return this.m_sOperator;
    }

    @Nonnull
    public String opFull() {
        return this.m_sOperator + '=';
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.generable(this.m_aLhs).print(this.opFull()).generable(this.m_aRhs);
    }

    @Override
    public void state(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.generable(this).print(';').newline();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JAssignment jAssignment = (JAssignment)object;
        return JCEqualsHelper.isEqual(this.m_aLhs, jAssignment.m_aLhs) && JCEqualsHelper.isEqual(this.m_aRhs, jAssignment.m_aRhs) && JCEqualsHelper.isEqual(this.m_sOperator, jAssignment.m_sOperator);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this.m_aLhs, this.m_aRhs, this.m_sOperator);
    }
}

