/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJAnnotationValue;
import com.helger.jcodemodel.AbstractJAnnotationValueOwned;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.JAnnotationArrayMember;
import com.helger.jcodemodel.JAnnotationStringValue;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JEnumConstant;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JAnnotationUse
extends AbstractJAnnotationValueOwned {
    public static final String SPECIAL_KEY_VALUE = "value";
    private final AbstractJClass m_aAnnotationClass;
    private final Map<String, AbstractJAnnotationValue> m_aMemberValues = new LinkedHashMap<String, AbstractJAnnotationValue>();

    public JAnnotationUse(@Nonnull AbstractJClass abstractJClass) {
        this.m_aAnnotationClass = JCValueEnforcer.notNull(abstractJClass, "AnnotationClass");
    }

    @Nonnull
    public AbstractJClass getAnnotationClass() {
        return this.m_aAnnotationClass;
    }

    @Override
    @Nonnull
    public JCodeModel owner() {
        return this.m_aAnnotationClass.owner();
    }

    @Nonnull
    public Map<String, AbstractJAnnotationValue> annotationMembersMutable() {
        return this.m_aMemberValues;
    }

    @Nonnull
    public Map<String, AbstractJAnnotationValue> getAnnotationMembers() {
        return Collections.unmodifiableMap(this.annotationMembersMutable());
    }

    public boolean hasAnnotationMembers() {
        return !this.m_aMemberValues.isEmpty();
    }

    @Nullable
    public AbstractJAnnotationValue getParam(@Nullable String string) {
        return this.m_aMemberValues.get(string);
    }

    private static <T> T _castAnnotationArgument(@Nullable AbstractJAnnotationValue abstractJAnnotationValue, @Nonnull Class<T> clazz) throws ClassCastException {
        if (!clazz.isArray()) {
            if (abstractJAnnotationValue == null) {
                throw new ClassCastException("Can't cast null annotation value to " + clazz + " class");
            }
            if (JAnnotationUse.class.isAssignableFrom(clazz)) {
                return clazz.cast(abstractJAnnotationValue);
            }
            if (!(abstractJAnnotationValue instanceof JAnnotationStringValue)) {
                throw new ClassCastException("Can't cast " + abstractJAnnotationValue + " annotation value to " + clazz + " class");
            }
            JAnnotationStringValue jAnnotationStringValue = (JAnnotationStringValue)abstractJAnnotationValue;
            return (T)jAnnotationStringValue.nativeValue();
        }
        if (abstractJAnnotationValue == null) {
            return (T)Array.newInstance(clazz.getComponentType(), 0);
        }
        JAnnotationArrayMember jAnnotationArrayMember = (JAnnotationArrayMember)abstractJAnnotationValue;
        List<AbstractJAnnotationValue> list = jAnnotationArrayMember.getAllAnnotations();
        Object[] objectArray = (Object[])Array.newInstance(clazz.getComponentType(), list.size());
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = JAnnotationUse._castAnnotationArgument((AbstractJAnnotationValue)iterator.next(), clazz.getComponentType());
            ++n;
        }
        return (T)objectArray;
    }

    @Nullable
    public <T> T getParam(@Nonnull String string, @Nonnull Class<T> clazz) throws ClassCastException {
        AbstractJAnnotationValue abstractJAnnotationValue = this.getParam(string);
        return JAnnotationUse._castAnnotationArgument(abstractJAnnotationValue, clazz);
    }

    @Nullable
    public JAnnotationStringValue getConstantParam(@Nullable String string) {
        AbstractJAnnotationValue abstractJAnnotationValue = this.getParam(string);
        return abstractJAnnotationValue instanceof JAnnotationStringValue ? (JAnnotationStringValue)abstractJAnnotationValue : null;
    }

    @Nullable
    public IJExpression getConstantParamValue(@Nullable String string) {
        JAnnotationStringValue jAnnotationStringValue = this.getConstantParam(string);
        return jAnnotationStringValue != null ? jAnnotationStringValue.value() : null;
    }

    @Nonnull
    private JAnnotationUse _addValue(@Nonnull String string, @Nonnull AbstractJAnnotationValue abstractJAnnotationValue) {
        JCValueEnforcer.notEmpty(string, "Name");
        JCValueEnforcer.notNull(abstractJAnnotationValue, "AnnotationValue");
        this.m_aMemberValues.put(string, abstractJAnnotationValue);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(boolean bl) {
        return this.param(SPECIAL_KEY_VALUE, bl);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, boolean bl) {
        return this._addValue(string, JAnnotationUse.wrap(bl));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, boolean ... blArray) {
        this.paramArray(string).params(blArray);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(byte by) {
        return this.param(SPECIAL_KEY_VALUE, by);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, byte by) {
        return this._addValue(string, JAnnotationUse.wrap(by));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, byte ... byArray) {
        this.paramArray(string).params(byArray);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(char c) {
        return this.param(SPECIAL_KEY_VALUE, c);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, char c) {
        return this._addValue(string, JAnnotationUse.wrap(c));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, char ... cArray) {
        this.paramArray(string).params(cArray);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(double d) {
        return this.param(SPECIAL_KEY_VALUE, d);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, double d) {
        return this._addValue(string, JAnnotationUse.wrap(d));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, double ... dArray) {
        this.paramArray(string).params(dArray);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(float f) {
        return this.param(SPECIAL_KEY_VALUE, f);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, float f) {
        return this._addValue(string, JAnnotationUse.wrap(f));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, float ... fArray) {
        this.paramArray(string).params(fArray);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(int n) {
        return this.param(SPECIAL_KEY_VALUE, n);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, int n) {
        return this._addValue(string, JAnnotationUse.wrap(n));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, int ... nArray) {
        this.paramArray(string).params(nArray);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(long l) {
        return this.param(SPECIAL_KEY_VALUE, l);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, long l) {
        return this._addValue(string, JAnnotationUse.wrap(l));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, long ... lArray) {
        this.paramArray(string).params(lArray);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(short s) {
        return this.param(SPECIAL_KEY_VALUE, s);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, short s) {
        return this._addValue(string, JAnnotationUse.wrap(s));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, short ... sArray) {
        this.paramArray(string).params(sArray);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string) {
        return this.param(SPECIAL_KEY_VALUE, string);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, @Nonnull String string2) {
        return this._addValue(string, JAnnotationUse.wrap(string2));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, String ... stringArray) {
        this.paramArray(string).params(stringArray);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull Enum<?> enum_) {
        return this.param(SPECIAL_KEY_VALUE, enum_);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, @Nonnull Enum<?> enum_) {
        return this._addValue(string, this.wrap(enum_));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, Enum<?> ... enumArray) {
        this.paramArray(string).params(enumArray);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull JEnumConstant jEnumConstant) {
        return this.param(SPECIAL_KEY_VALUE, jEnumConstant);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, @Nonnull JEnumConstant jEnumConstant) {
        return this._addValue(string, JAnnotationUse.wrap(jEnumConstant));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, JEnumConstant ... jEnumConstantArray) {
        this.paramArray(string).params(jEnumConstantArray);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull Class<?> clazz) {
        return this.param(SPECIAL_KEY_VALUE, clazz);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, @Nonnull Class<?> clazz) {
        return this._addValue(string, this.wrap(clazz));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, Class<?> ... classArray) {
        this.paramArray(string).params(classArray);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull AbstractJType abstractJType) {
        return this.param(SPECIAL_KEY_VALUE, abstractJType);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, @Nonnull AbstractJType abstractJType) {
        return this._addValue(string, JAnnotationUse.wrap(abstractJType));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, AbstractJType ... abstractJTypeArray) {
        this.paramArray(string).params(abstractJTypeArray);
        return this;
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull IJExpression iJExpression) {
        return this.param(SPECIAL_KEY_VALUE, iJExpression);
    }

    @Nonnull
    public JAnnotationUse param(@Nonnull String string, @Nonnull IJExpression iJExpression) {
        return this._addValue(string, JAnnotationUse.wrap(iJExpression));
    }

    @Nonnull
    public JAnnotationUse paramArray(@Nonnull String string, IJExpression ... iJExpressionArray) {
        this.paramArray(string).params(iJExpressionArray);
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember paramArray(@Nonnull String string) {
        JAnnotationArrayMember jAnnotationArrayMember = new JAnnotationArrayMember(this.owner());
        this._addValue(string, jAnnotationArrayMember);
        return jAnnotationArrayMember;
    }

    @Nonnull
    public JAnnotationUse annotationParam(@Nonnull String string, @Nonnull Class<? extends Annotation> clazz) {
        return this.annotationParam(string, this.owner().ref(clazz));
    }

    @Nonnull
    public JAnnotationUse annotationParam(@Nonnull String string, @Nonnull AbstractJClass abstractJClass) {
        JAnnotationUse jAnnotationUse = new JAnnotationUse(abstractJClass);
        this._addValue(string, jAnnotationUse);
        return jAnnotationUse;
    }

    @Nonnegative
    public int size() {
        return this.m_aMemberValues.size();
    }

    public boolean isDefaultOnly() {
        return this.m_aMemberValues.size() == 1 && this.m_aMemberValues.containsKey(SPECIAL_KEY_VALUE);
    }

    @Override
    public void generate(IJFormatter iJFormatter) {
        iJFormatter.print('@').generable(this.m_aAnnotationClass);
        if (!this.m_aMemberValues.isEmpty()) {
            iJFormatter.print('(');
            if (this.isDefaultOnly()) {
                iJFormatter.generable(this.m_aMemberValues.get(SPECIAL_KEY_VALUE));
            } else {
                boolean bl = true;
                for (Map.Entry<String, AbstractJAnnotationValue> entry : this.m_aMemberValues.entrySet()) {
                    if (bl) {
                        bl = false;
                    } else {
                        iJFormatter.print(',');
                    }
                    iJFormatter.print(entry.getKey()).print('=').generable(entry.getValue());
                }
            }
            iJFormatter.print(')');
        }
    }
}

