/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJAnnotationValue;
import com.helger.jcodemodel.AbstractJAnnotationValueOwned;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JEnumConstant;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class JAnnotationArrayMember
extends AbstractJAnnotationValueOwned
implements IJAnnotatable {
    private final JCodeModel m_aOwner;
    private final List<AbstractJAnnotationValue> m_aValues = new ArrayList<AbstractJAnnotationValue>();

    public JAnnotationArrayMember(@Nonnull JCodeModel jCodeModel) {
        JCValueEnforcer.notNull(jCodeModel, "Owner");
        this.m_aOwner = jCodeModel;
    }

    @Override
    @Nonnull
    public JCodeModel owner() {
        return this.m_aOwner;
    }

    @Nonnull
    public JAnnotationArrayMember param(@Nonnull String string) {
        this.m_aValues.add(JAnnotationArrayMember.wrap(string));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(String ... stringArray) {
        for (String string : stringArray) {
            this.m_aValues.add(JAnnotationArrayMember.wrap(string));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(boolean bl) {
        this.m_aValues.add(JAnnotationArrayMember.wrap(bl));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(boolean ... blArray) {
        for (boolean bl : blArray) {
            this.m_aValues.add(JAnnotationArrayMember.wrap(bl));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(byte by) {
        this.m_aValues.add(JAnnotationArrayMember.wrap(by));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(byte ... byArray) {
        for (byte by : byArray) {
            this.m_aValues.add(JAnnotationArrayMember.wrap(by));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(char c) {
        this.m_aValues.add(JAnnotationArrayMember.wrap(c));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(char ... cArray) {
        for (char c : cArray) {
            this.m_aValues.add(JAnnotationArrayMember.wrap(c));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(double d) {
        this.m_aValues.add(JAnnotationArrayMember.wrap(d));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(double ... dArray) {
        for (double d : dArray) {
            this.m_aValues.add(JAnnotationArrayMember.wrap(d));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(long l) {
        this.m_aValues.add(JAnnotationArrayMember.wrap(l));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(long ... lArray) {
        for (long l : lArray) {
            this.m_aValues.add(JAnnotationArrayMember.wrap(l));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(short s) {
        this.m_aValues.add(JAnnotationArrayMember.wrap(s));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(short ... sArray) {
        for (short s : sArray) {
            this.m_aValues.add(JAnnotationArrayMember.wrap(s));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(int n) {
        this.m_aValues.add(JAnnotationArrayMember.wrap(n));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(int ... nArray) {
        for (int n : nArray) {
            this.m_aValues.add(JAnnotationArrayMember.wrap(n));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(float f) {
        this.m_aValues.add(JAnnotationArrayMember.wrap(f));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(float ... fArray) {
        for (float f : fArray) {
            this.m_aValues.add(JAnnotationArrayMember.wrap(f));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(@Nonnull Enum<?> enum_) {
        this.m_aValues.add(this.wrap(enum_));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(Enum<?> ... enumArray) {
        for (Enum<?> enum_ : enumArray) {
            this.m_aValues.add(this.wrap(enum_));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(JEnumConstant jEnumConstant) {
        this.m_aValues.add(JAnnotationArrayMember.wrap(jEnumConstant));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(JEnumConstant ... jEnumConstantArray) {
        for (JEnumConstant jEnumConstant : jEnumConstantArray) {
            this.m_aValues.add(JAnnotationArrayMember.wrap(jEnumConstant));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(IJExpression iJExpression) {
        this.m_aValues.add(JAnnotationArrayMember.wrap(iJExpression));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(IJExpression ... iJExpressionArray) {
        for (IJExpression iJExpression : iJExpressionArray) {
            this.m_aValues.add(JAnnotationArrayMember.wrap(iJExpression));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(Class<?> clazz) {
        this.m_aValues.add(this.wrap(clazz));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this.m_aValues.add(this.wrap(clazz));
        }
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember param(AbstractJType abstractJType) {
        this.m_aValues.add(JAnnotationArrayMember.wrap(abstractJType));
        return this;
    }

    @Nonnull
    public JAnnotationArrayMember params(AbstractJType ... abstractJTypeArray) {
        for (AbstractJType abstractJType : abstractJTypeArray) {
            this.m_aValues.add(JAnnotationArrayMember.wrap(abstractJType));
        }
        return this;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull Class<? extends Annotation> clazz) {
        return this.annotate(this.owner().ref(clazz));
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull AbstractJClass abstractJClass) {
        JAnnotationUse jAnnotationUse = new JAnnotationUse(abstractJClass);
        this.m_aValues.add(jAnnotationUse);
        return jAnnotationUse;
    }

    @Nonnull
    public List<JAnnotationUse> annotations() {
        return Collections.unmodifiableList(this.m_aValues);
    }

    @Nonnull
    public List<AbstractJAnnotationValue> annotationsMutable() {
        return this.m_aValues;
    }

    @Nonnull
    public List<AbstractJAnnotationValue> getAllAnnotations() {
        return Collections.unmodifiableList(this.annotationsMutable());
    }

    @Nonnegative
    public int size() {
        return this.m_aValues.size();
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.print('{').newline().indent();
        boolean bl = true;
        for (AbstractJAnnotationValue abstractJAnnotationValue : this.m_aValues) {
            if (!bl) {
                iJFormatter.print(',').newline();
            }
            iJFormatter.generable(abstractJAnnotationValue);
            bl = false;
        }
        iJFormatter.newline().outdent().print('}');
    }
}

