/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue;

import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.QueueStore;
import com.hazelcast.core.QueueStoreFactory;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class QueueStoreWrapper
implements QueueStore<Data> {
    private static final int DEFAULT_MEMORY_LIMIT = 1000;
    private static final int DEFAULT_BULK_LOAD = 250;
    private QueueStore store;
    private QueueStoreConfig storeConfig;
    private boolean enabled = false;
    private int memoryLimit = 1000;
    private int bulkLoad = 250;
    private boolean binary = false;
    private final SerializationService serializationService;

    public QueueStoreWrapper(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    public void setConfig(QueueStoreConfig storeConfig, String name) {
        if (storeConfig == null) {
            return;
        }
        this.store = storeConfig.getStoreImplementation();
        if (this.store == null) {
            try {
                this.store = (QueueStore)ClassLoaderUtil.newInstance(this.serializationService.getClassLoader(), storeConfig.getClassName());
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (this.store == null) {
            QueueStoreFactory factory = storeConfig.getFactoryImplementation();
            if (factory == null) {
                try {
                    factory = (QueueStoreFactory)ClassLoaderUtil.newInstance(this.serializationService.getClassLoader(), storeConfig.getFactoryClassName());
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (factory == null) {
                return;
            }
            this.store = factory.newQueueStore(name, storeConfig.getProperties());
        }
        this.storeConfig = storeConfig;
        this.enabled = storeConfig.isEnabled();
        this.binary = Boolean.parseBoolean(storeConfig.getProperty("binary"));
        this.memoryLimit = this.parseInt("memory-limit", 1000);
        this.bulkLoad = this.parseInt("bulk-load", 250);
        if (this.bulkLoad < 1) {
            this.bulkLoad = 1;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public int getMemoryLimit() {
        return this.memoryLimit;
    }

    public int getBulkLoad() {
        return this.bulkLoad;
    }

    @Override
    public void store(Long key, Data value) {
        if (this.enabled) {
            Object actualValue;
            if (this.binary) {
                BufferObjectDataOutput out = this.serializationService.createObjectDataOutput(value.totalSize());
                try {
                    value.writeData(out);
                    actualValue = out.getBuffer();
                }
                catch (IOException e) {
                    throw new HazelcastException(e);
                }
                finally {
                    IOUtil.closeResource(out);
                }
            } else {
                actualValue = this.serializationService.toObject(value);
            }
            this.store.store(key, actualValue);
        }
    }

    @Override
    public void storeAll(Map<Long, Data> map) {
        if (this.enabled) {
            HashMap<Long, Object> objectMap = new HashMap<Long, Object>(map.size());
            if (this.binary) {
                BufferObjectDataOutput out = this.serializationService.createObjectDataOutput(1024);
                try {
                    for (Map.Entry<Long, Data> entry : map.entrySet()) {
                        entry.getValue().writeData(out);
                        objectMap.put(entry.getKey(), out.toByteArray());
                        out.clear();
                    }
                }
                catch (IOException e) {
                    throw new HazelcastException(e);
                }
                finally {
                    IOUtil.closeResource(out);
                }
            } else {
                for (Map.Entry<Long, Data> entry : map.entrySet()) {
                    objectMap.put(entry.getKey(), this.serializationService.toObject(entry.getValue()));
                }
            }
            this.store.storeAll(objectMap);
        }
    }

    @Override
    public void delete(Long key) {
        if (this.enabled) {
            this.store.delete(key);
        }
    }

    @Override
    public void deleteAll(Collection<Long> keys) {
        if (this.enabled) {
            this.store.deleteAll(keys);
        }
    }

    @Override
    public Data load(Long key) {
        if (this.enabled) {
            Object val = this.store.load(key);
            if (this.binary) {
                byte[] dataBuffer = (byte[])val;
                BufferObjectDataInput in = this.serializationService.createObjectDataInput(dataBuffer);
                Data data = new Data();
                try {
                    data.readData(in);
                }
                catch (IOException e) {
                    throw new HazelcastException(e);
                }
                return data;
            }
            return this.serializationService.toData(val);
        }
        return null;
    }

    @Override
    public Map<Long, Data> loadAll(Collection<Long> keys) {
        if (this.enabled) {
            Map<Long, Data> map = this.store.loadAll(keys);
            if (map == null) {
                return Collections.emptyMap();
            }
            HashMap<Long, Data> dataMap = new HashMap<Long, Data>(map.size());
            if (this.binary) {
                for (Map.Entry entry : map.entrySet()) {
                    byte[] dataBuffer = (byte[])entry.getValue();
                    BufferObjectDataInput in = this.serializationService.createObjectDataInput(dataBuffer);
                    Data data = new Data();
                    try {
                        data.readData(in);
                    }
                    catch (IOException e) {
                        throw new HazelcastException(e);
                    }
                    dataMap.put(entry.getKey(), data);
                }
                return map;
            }
            for (Map.Entry entry : map.entrySet()) {
                dataMap.put(entry.getKey(), this.serializationService.toData(entry.getValue()));
            }
            return dataMap;
        }
        return null;
    }

    @Override
    public Set<Long> loadAllKeys() {
        if (this.enabled) {
            return this.store.loadAllKeys();
        }
        return null;
    }

    private int parseInt(String name, int defaultValue) {
        String val = this.storeConfig.getProperty(name);
        if (val == null || val.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

