/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.instance.Node;
import com.hazelcast.logging.SystemLogRecord;
import com.hazelcast.logging.SystemLogService;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class GetLogsRequest
implements ConsoleRequest {
    @Override
    public int getType() {
        return 11;
    }

    @Override
    public Object readResponse(ObjectDataInput in) throws IOException {
        LinkedList<SystemLogRecord> list = new LinkedList<SystemLogRecord>();
        String node = in.readUTF();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            SystemLogRecord systemLogRecord = new SystemLogRecord();
            systemLogRecord.readData(in);
            systemLogRecord.setNode(node);
            list.add(systemLogRecord);
        }
        return list;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, ObjectDataOutput dos) throws Exception {
        Node node = mcs.getHazelcastInstance().node;
        SystemLogService systemLogService = node.getSystemLogService();
        List<SystemLogRecord> logBundle = systemLogService.getLogBundle();
        Address address = node.getThisAddress();
        dos.writeUTF(address.getHost() + ":" + address.getPort());
        dos.writeInt(logBundle.size());
        for (SystemLogRecord systemLogRecord : logBundle) {
            systemLogRecord.writeData(dos);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
    }
}

