/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.operations.UnlockOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class LockEvictionProcessor
implements ScheduledEntryProcessor<Data, Object> {
    private static final int AWAIT_COMPLETION_TIMEOUT_SECONDS = 30;
    private final NodeEngine nodeEngine;
    private final ObjectNamespace namespace;

    public LockEvictionProcessor(NodeEngine nodeEngine, ObjectNamespace namespace) {
        this.nodeEngine = nodeEngine;
        this.namespace = namespace;
    }

    @Override
    public void process(EntryTaskScheduler<Data, Object> scheduler, Collection<ScheduledEntry<Data, Object>> entries) {
        Collection<Future> futures = this.sendUnlockOperations(entries);
        this.awaitCompletion(futures);
    }

    private Collection<Future> sendUnlockOperations(Collection<ScheduledEntry<Data, Object>> entries) {
        ArrayList<Future> futures = new ArrayList<Future>(entries.size());
        for (ScheduledEntry<Data, Object> entry : entries) {
            Data key = entry.getKey();
            this.sendUnlockOperation(futures, key);
        }
        return futures;
    }

    private void sendUnlockOperation(Collection<Future> futures, Data key) {
        UnlockOperation operation = new UnlockOperation(this.namespace, key, -1L, true);
        try {
            InternalCompletableFuture f = this.invoke(operation, key);
            futures.add(f);
        }
        catch (Throwable t) {
            ILogger logger = this.nodeEngine.getLogger(this.getClass());
            logger.warning(t);
        }
    }

    private void awaitCompletion(Collection<Future> futures) {
        ILogger logger = this.nodeEngine.getLogger(this.getClass());
        for (Future future : futures) {
            try {
                future.get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                logger.finest(e);
            }
            catch (Exception e) {
                logger.warning(e);
            }
        }
    }

    private InternalCompletableFuture invoke(Operation operation, Data key) {
        int partitionId = this.nodeEngine.getPartitionService().getPartitionId(key);
        OperationService operationService = this.nodeEngine.getOperationService();
        return operationService.invokeOnPartition("hz:impl:lockService", operation, partitionId);
    }
}

