/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.client;

import com.hazelcast.cluster.client.MemberAttributeChange;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public final class ClientMembershipEvent
implements IdentifiedDataSerializable {
    public static final int MEMBER_ADDED = 1;
    public static final int MEMBER_REMOVED = 2;
    public static final int MEMBER_ATTRIBUTE_CHANGED = 5;
    private Member member;
    private MemberAttributeChange memberAttributeChange;
    private int eventType;

    public ClientMembershipEvent() {
    }

    public ClientMembershipEvent(Member member, int eventType) {
        this(member, null, eventType);
    }

    public ClientMembershipEvent(Member member, MemberAttributeChange memberAttributeChange) {
        this(member, memberAttributeChange, 5);
    }

    private ClientMembershipEvent(Member member, MemberAttributeChange memberAttributeChange, int eventType) {
        this.member = member;
        this.eventType = eventType;
        this.memberAttributeChange = memberAttributeChange;
    }

    public int getEventType() {
        return this.eventType;
    }

    public Member getMember() {
        return this.member;
    }

    public MemberAttributeChange getMemberAttributeChange() {
        return this.memberAttributeChange;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.member.writeData(out);
        out.writeInt(this.eventType);
        out.writeBoolean(this.memberAttributeChange != null);
        if (this.memberAttributeChange != null) {
            this.memberAttributeChange.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.member = new MemberImpl();
        this.member.readData(in);
        this.eventType = in.readInt();
        if (in.readBoolean()) {
            this.memberAttributeChange = new MemberAttributeChange();
            this.memberAttributeChange.readData(in);
        }
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 8;
    }
}

