/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.retirejs.util;

public class CompareVersionUtil {
    public static boolean isUnder(String version, String under) {
        String[] v1Parts = version.split("[\\.\\-]");
        String[] v2Parts = under.split("[\\.\\-]");
        int numberParts = Math.max(v1Parts.length, v2Parts.length);
        for (int i = 0; i < numberParts; ++i) {
            int version2Segment;
            if (v2Parts.length > i && "*".equals(v2Parts[i])) continue;
            int version1Segment = CompareVersionUtil.versionPartToInteger(v1Parts, i);
            if (version1Segment > (version2Segment = CompareVersionUtil.versionPartToInteger(v2Parts, i))) {
                return false;
            }
            if (version1Segment >= version2Segment) continue;
            return true;
        }
        return false;
    }

    public static boolean atOrAbove(String version, String atOrAbove) {
        String[] v1Parts = version.split("[\\.\\-]");
        String[] v2Parts = atOrAbove.split("[\\.\\-]");
        int numberParts = Math.max(v1Parts.length, v2Parts.length);
        for (int i = 0; i < numberParts; ++i) {
            int version2Segment;
            if (v2Parts.length > i && "*".equals(v2Parts[i])) continue;
            int version1Segment = CompareVersionUtil.versionPartToInteger(v1Parts, i);
            if (version1Segment < (version2Segment = CompareVersionUtil.versionPartToInteger(v2Parts, i))) {
                return false;
            }
            if (version1Segment <= version2Segment) continue;
            return true;
        }
        return true;
    }

    private static int versionPartToInteger(String[] value, int index) {
        if (value.length <= index) {
            return 0;
        }
        try {
            return Integer.parseInt(value[index]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

