/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.kotlinmodule.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import kotlinx.metadata.jvm.KotlinClassHeader;
import proguard.classfile.kotlin.KotlinMetadataVersion;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.resources.file.ResourceFilePool;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;
import proguard.resources.kotlinmodule.io.KotlinModuleWriter;

public class KotlinModuleDataEntryWriter
implements DataEntryWriter {
    private final ResourceFilePool resourceFilePool;
    private final DataEntryWriter dataEntryWriter;
    private final KotlinMetadataVersion version;

    public KotlinModuleDataEntryWriter(ResourceFilePool resourceFilePool, DataEntryWriter dataEntryWriter) {
        this(resourceFilePool, dataEntryWriter, new KotlinMetadataVersion(KotlinClassHeader.COMPATIBLE_METADATA_VERSION));
    }

    public KotlinModuleDataEntryWriter(ResourceFilePool resourceFilePool, DataEntryWriter dataEntryWriter, KotlinMetadataVersion version) {
        this.resourceFilePool = resourceFilePool;
        this.dataEntryWriter = dataEntryWriter;
        this.version = version;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createDirectory(dataEntry);
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter.sameOutputStream(dataEntry1, dataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        KotlinModuleGetter kotlinModuleGetter = new KotlinModuleGetter();
        this.resourceFilePool.resourceFileAccept(dataEntry.getName(), kotlinModuleGetter);
        KotlinModule kotlinModule = kotlinModuleGetter.kotlinModule;
        if (kotlinModule != null) {
            BufferedOutputStream outputStream = new BufferedOutputStream(this.dataEntryWriter.createOutputStream(dataEntry));
            kotlinModule.accept(new KotlinModuleWriter(outputStream, this.version));
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    @Override
    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "KotlinModuleDataEntryWriter");
        this.dataEntryWriter.println(pw, prefix);
    }

    private static class KotlinModuleGetter
    implements ResourceFileVisitor {
        KotlinModule kotlinModule;

        private KotlinModuleGetter() {
        }

        @Override
        public void visitKotlinModule(KotlinModule kotlinModule) {
            this.kotlinModule = kotlinModule;
        }
    }
}

