/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.ByteSerializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraySerializer
extends Serializer {
    private final Kryo kryo;
    private Integer fixedDimensionCount;
    private boolean elementsAreSameType;
    private boolean elementsCanBeNull = true;
    private int[] dimensions;

    public ArraySerializer(Kryo kryo) {
        this.kryo = kryo;
    }

    public void setDimensionCount(Integer dimensions) {
        this.fixedDimensionCount = dimensions;
    }

    public void setLength(int length) {
        this.dimensions = new int[]{length};
    }

    public void setLengths(int[] lengths) {
        this.dimensions = lengths;
    }

    public void setElementsCanBeNull(boolean elementsCanBeNull) {
        this.elementsCanBeNull = elementsCanBeNull;
    }

    public void setElementsAreSameType(boolean elementsAreSameType) {
        this.elementsAreSameType = elementsAreSameType;
    }

    @Override
    public void writeObjectData(ByteBuffer buffer, Object array) {
        boolean elementsCanBeNull;
        int[] dimensions = this.dimensions;
        if (dimensions == null) {
            dimensions = ArraySerializer.getDimensions(array);
            if (this.fixedDimensionCount == null) {
                ByteSerializer.putUnsigned(buffer, dimensions.length);
            }
            int n = dimensions.length;
            for (int i = 0; i < n; ++i) {
                IntSerializer.put(buffer, dimensions[i], true);
            }
        }
        Serializer elementSerializer = null;
        Class elementClass = ArraySerializer.getElementClass(array.getClass());
        boolean bl = elementsCanBeNull = this.elementsCanBeNull && !elementClass.isPrimitive();
        if (this.elementsAreSameType || Modifier.isFinal(elementClass.getModifiers())) {
            elementSerializer = this.kryo.getRegisteredClass(elementClass).getSerializer();
        }
        this.writeArray(buffer, array, elementSerializer, 0, dimensions.length, elementsCanBeNull);
        if (Log.TRACE) {
            StringBuilder stringBuffer = new StringBuilder(16);
            int n = dimensions.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append('[');
                stringBuffer.append(dimensions[i]);
                stringBuffer.append(']');
            }
            Log.trace((String)"kryo", (String)("Wrote array: " + elementClass.getName() + stringBuffer));
        }
    }

    private void writeArray(ByteBuffer buffer, Object array, Serializer elementSerializer, int dimension, int dimensionCount, boolean elementsCanBeNull) {
        int length = Array.getLength(array);
        if (dimension > 0) {
            IntSerializer.put(buffer, length, true);
        }
        boolean elementsAreArrays = dimension < dimensionCount - 1;
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            if (elementsAreArrays) {
                if (element == null) continue;
                this.writeArray(buffer, element, elementSerializer, dimension + 1, dimensionCount, elementsCanBeNull);
                continue;
            }
            if (elementSerializer != null) {
                if (elementsCanBeNull) {
                    elementSerializer.writeObject(buffer, element);
                    continue;
                }
                elementSerializer.writeObjectData(buffer, element);
                continue;
            }
            this.kryo.writeClassAndObject(buffer, element);
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer buffer, Class<T> type) {
        boolean elementsCanBeNull;
        int dimensionCount;
        int[] dimensions = this.dimensions;
        if (dimensions == null) {
            dimensionCount = this.fixedDimensionCount != null ? this.fixedDimensionCount : ByteSerializer.getUnsigned(buffer);
            dimensions = new int[dimensionCount];
            for (int i = 0; i < dimensionCount; ++i) {
                dimensions[i] = IntSerializer.get(buffer, true);
            }
        } else {
            dimensionCount = dimensions.length;
        }
        Serializer elementSerializer = null;
        Class elementClass = ArraySerializer.getElementClass(type);
        boolean bl = elementsCanBeNull = this.elementsCanBeNull && !elementClass.isPrimitive();
        if (this.elementsAreSameType || Modifier.isFinal(elementClass.getModifiers())) {
            elementSerializer = this.kryo.getRegisteredClass(elementClass).getSerializer();
        }
        Object array = Array.newInstance(elementClass, dimensions);
        this.readArray(buffer, array, elementSerializer, elementClass, 0, dimensions, elementsCanBeNull);
        if (Log.TRACE) {
            StringBuilder stringBuffer = new StringBuilder(16);
            for (int i = 0; i < dimensionCount; ++i) {
                stringBuffer.append('[');
                stringBuffer.append(dimensions[i]);
                stringBuffer.append(']');
            }
            Log.trace((String)"kryo", (String)("Read array: " + elementClass.getName() + stringBuffer));
        }
        return (T)array;
    }

    private void readArray(ByteBuffer buffer, Object array, Serializer elementSerializer, Class elementClass, int dimension, int[] dimensions, boolean elementsCanBeNull) {
        boolean elementsAreArrays = dimension < dimensions.length - 1;
        int length = dimension == 0 ? dimensions[0] : IntSerializer.get(buffer, true);
        for (int i = 0; i < length; ++i) {
            if (elementsAreArrays) {
                Object element = Array.get(array, i);
                if (element == null) continue;
                this.readArray(buffer, element, elementSerializer, elementClass, dimension + 1, dimensions, elementsCanBeNull);
                continue;
            }
            if (elementSerializer != null) {
                if (elementsCanBeNull) {
                    Array.set(array, i, elementSerializer.readObject(buffer, elementClass));
                    continue;
                }
                Array.set(array, i, elementSerializer.readObjectData(buffer, elementClass));
                continue;
            }
            Array.set(array, i, this.kryo.readClassAndObject(buffer));
        }
    }

    public static int getDimensionCount(Class arrayClass) {
        int depth = 0;
        for (Class<?> nextClass = arrayClass.getComponentType(); nextClass != null; nextClass = nextClass.getComponentType()) {
            ++depth;
        }
        return depth;
    }

    public static int[] getDimensions(Object array) {
        int depth = 0;
        for (Class<?> nextClass = array.getClass().getComponentType(); nextClass != null; nextClass = nextClass.getComponentType()) {
            ++depth;
        }
        int[] dimensions = new int[depth];
        dimensions[0] = Array.getLength(array);
        if (depth > 1) {
            ArraySerializer.collectDimensions(array, 1, dimensions);
        }
        return dimensions;
    }

    private static void collectDimensions(Object array, int dimension, int[] dimensions) {
        boolean elementsAreArrays = dimension < dimensions.length - 1;
        int s = Array.getLength(array);
        for (int i = 0; i < s; ++i) {
            Object element = Array.get(array, i);
            if (element == null) continue;
            dimensions[dimension] = Math.max(dimensions[dimension], Array.getLength(element));
            if (!elementsAreArrays) continue;
            ArraySerializer.collectDimensions(element, dimension + 1, dimensions);
        }
    }

    public static Class getElementClass(Class arrayClass) {
        Class<?> elementClass = arrayClass;
        while (elementClass.getComponentType() != null) {
            elementClass = elementClass.getComponentType();
        }
        return elementClass;
    }
}

