/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GenerationConfig;
import com.google.genai.types.GenerationConfigRoutingConfig;
import com.google.genai.types.MediaResolution;
import com.google.genai.types.Schema;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GenerationConfig
extends JsonSerializable {
    @JsonProperty(value="audioTimestamp")
    public abstract Optional<Boolean> audioTimestamp();

    @JsonProperty(value="candidateCount")
    public abstract Optional<Integer> candidateCount();

    @JsonProperty(value="frequencyPenalty")
    public abstract Optional<Float> frequencyPenalty();

    @JsonProperty(value="logprobs")
    public abstract Optional<Integer> logprobs();

    @JsonProperty(value="maxOutputTokens")
    public abstract Optional<Integer> maxOutputTokens();

    @JsonProperty(value="mediaResolution")
    public abstract Optional<MediaResolution> mediaResolution();

    @JsonProperty(value="presencePenalty")
    public abstract Optional<Float> presencePenalty();

    @JsonProperty(value="responseLogprobs")
    public abstract Optional<Boolean> responseLogprobs();

    @JsonProperty(value="responseMimeType")
    public abstract Optional<String> responseMimeType();

    @JsonProperty(value="responseSchema")
    public abstract Optional<Schema> responseSchema();

    @JsonProperty(value="routingConfig")
    public abstract Optional<GenerationConfigRoutingConfig> routingConfig();

    @JsonProperty(value="seed")
    public abstract Optional<Integer> seed();

    @JsonProperty(value="stopSequences")
    public abstract Optional<List<String>> stopSequences();

    @JsonProperty(value="temperature")
    public abstract Optional<Float> temperature();

    @JsonProperty(value="topK")
    public abstract Optional<Float> topK();

    @JsonProperty(value="topP")
    public abstract Optional<Float> topP();

    public static Builder builder() {
        return new AutoValue_GenerationConfig.Builder();
    }

    public abstract Builder toBuilder();

    public static GenerationConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GenerationConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GenerationConfig.Builder();
        }

        @JsonProperty(value="audioTimestamp")
        public abstract Builder audioTimestamp(boolean var1);

        @JsonProperty(value="candidateCount")
        public abstract Builder candidateCount(Integer var1);

        @JsonProperty(value="frequencyPenalty")
        public abstract Builder frequencyPenalty(Float var1);

        @JsonProperty(value="logprobs")
        public abstract Builder logprobs(Integer var1);

        @JsonProperty(value="maxOutputTokens")
        public abstract Builder maxOutputTokens(Integer var1);

        @JsonProperty(value="mediaResolution")
        public abstract Builder mediaResolution(MediaResolution var1);

        @CanIgnoreReturnValue
        public Builder mediaResolution(MediaResolution.Known knownType) {
            return this.mediaResolution(new MediaResolution(knownType));
        }

        @CanIgnoreReturnValue
        public Builder mediaResolution(String mediaResolution) {
            return this.mediaResolution(new MediaResolution(mediaResolution));
        }

        @JsonProperty(value="presencePenalty")
        public abstract Builder presencePenalty(Float var1);

        @JsonProperty(value="responseLogprobs")
        public abstract Builder responseLogprobs(boolean var1);

        @JsonProperty(value="responseMimeType")
        public abstract Builder responseMimeType(String var1);

        @JsonProperty(value="responseSchema")
        public abstract Builder responseSchema(Schema var1);

        @JsonProperty(value="routingConfig")
        public abstract Builder routingConfig(GenerationConfigRoutingConfig var1);

        @JsonProperty(value="seed")
        public abstract Builder seed(Integer var1);

        @JsonProperty(value="stopSequences")
        public abstract Builder stopSequences(List<String> var1);

        @JsonProperty(value="temperature")
        public abstract Builder temperature(Float var1);

        @JsonProperty(value="topK")
        public abstract Builder topK(Float var1);

        @JsonProperty(value="topP")
        public abstract Builder topP(Float var1);

        public abstract GenerationConfig build();
    }
}

