/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Preconditions;
import com.google.genai.ApiClient;
import com.google.genai.AsyncCaches;
import com.google.genai.AsyncChats;
import com.google.genai.AsyncFiles;
import com.google.genai.AsyncLive;
import com.google.genai.AsyncModels;
import com.google.genai.AsyncOperations;
import com.google.genai.Caches;
import com.google.genai.Chats;
import com.google.genai.DebugConfig;
import com.google.genai.Files;
import com.google.genai.HttpApiClient;
import com.google.genai.Models;
import com.google.genai.Operations;
import com.google.genai.ReplayApiClient;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.HttpOptions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class Client
implements AutoCloseable {
    private static Optional<String> geminiBaseUrl = Optional.empty();
    private static Optional<String> vertexBaseUrl = Optional.empty();
    private final DebugConfig debugConfig;
    private final ApiClient apiClient;
    public final Models models;
    public final Caches caches;
    public final Operations operations;
    public final Chats chats;
    public final Files files;
    public final Async async;

    static Map<String, String> defaultEnvironmentVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        String value = System.getenv("GOOGLE_GENAI_USE_VERTEXAI");
        if (value != null) {
            variables.put("GOOGLE_GENAI_USE_VERTEXAI", value);
        }
        if ((value = System.getenv("GOOGLE_GEMINI_BASE_URL")) != null) {
            variables.put("GOOGLE_GEMINI_BASE_URL", value);
        }
        if ((value = System.getenv("GOOGLE_VERTEX_BASE_URL")) != null) {
            variables.put("GOOGLE_VERTEX_BASE_URL", value);
        }
        return variables;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Client() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private Client(Optional<String> apiKey, Optional<String> project, Optional<String> location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> httpOptions, Optional<Boolean> vertexAI, Optional<DebugConfig> debugConfig, Optional<Map<String, String>> environmentVariables) {
        boolean useVertexAI;
        Preconditions.checkNotNull(vertexAI, (Object)"vertexAI cannot be null");
        Preconditions.checkNotNull(debugConfig, (Object)"debugConfig cannot be null");
        if (!environmentVariables.isPresent()) {
            environmentVariables = Optional.of(Client.defaultEnvironmentVariables());
        }
        if (vertexAI.isPresent()) {
            useVertexAI = vertexAI.get();
        } else {
            String envVar = environmentVariables.get().get("GOOGLE_GENAI_USE_VERTEXAI");
            boolean bl = useVertexAI = envVar != null && envVar.equalsIgnoreCase("true");
        }
        if (project.isPresent() || location.isPresent()) {
            if (apiKey.isPresent()) {
                throw new IllegalArgumentException("Project/location and API key are mutually exclusive in the client initializer.");
            }
            if (!useVertexAI) {
                throw new IllegalArgumentException("Google AI APIs do not support project/location.");
            }
        }
        if (apiKey.isPresent() && useVertexAI) {
            throw new IllegalArgumentException("Vertex AI APIs do not support API key.");
        }
        Optional<String> baseUrl = Client.inferBaseUrl(useVertexAI, httpOptions, environmentVariables);
        if (baseUrl.isPresent()) {
            httpOptions = httpOptions.isPresent() ? Optional.of(httpOptions.get().toBuilder().baseUrl(baseUrl.get()).build()) : Optional.of(HttpOptions.builder().baseUrl(baseUrl.get()).build());
        }
        this.debugConfig = debugConfig.orElse(new DebugConfig());
        if (this.debugConfig.clientMode().equals("replay") || this.debugConfig.clientMode().equals("auto")) {
            System.out.println("Instantialing a client that will use Replay mode...");
            if (!useVertexAI) {
                System.out.println("Instantialing a replay client that will use Google AI APIs...");
                this.apiClient = new ReplayApiClient(apiKey, httpOptions, this.debugConfig.replaysDirectory(), this.debugConfig.replayId(), this.debugConfig.clientMode());
            } else {
                System.out.println("Instantialing a replay client that will use Vertex AI APIs...");
                this.apiClient = new ReplayApiClient(project, location, credentials, httpOptions, this.debugConfig.replaysDirectory(), this.debugConfig.replayId(), this.debugConfig.clientMode());
            }
        } else {
            this.apiClient = !useVertexAI ? new HttpApiClient(apiKey, httpOptions) : new HttpApiClient(project, location, credentials, httpOptions);
        }
        this.models = new Models(this.apiClient);
        this.caches = new Caches(this.apiClient);
        this.operations = new Operations(this.apiClient);
        this.chats = new Chats(this.apiClient);
        this.async = new Async(this.apiClient);
        this.files = new Files(this.apiClient);
    }

    public boolean vertexAI() {
        return this.apiClient.vertexAI();
    }

    public String project() {
        return this.apiClient.project();
    }

    public String location() {
        return this.apiClient.location();
    }

    public String apiKey() {
        return this.apiClient.apiKey();
    }

    protected void setReplayId(String replayId) {
        if (this.apiClient instanceof ReplayApiClient) {
            ((ReplayApiClient)this.apiClient).initializeReplaySession(replayId);
        }
    }

    DebugConfig debugConfig() {
        return this.debugConfig;
    }

    String clientMode() {
        return this.debugConfig.clientMode();
    }

    Optional<String> baseUrl() {
        if (this.apiClient.httpOptions.baseUrl().isPresent()) {
            return this.apiClient.httpOptions.baseUrl();
        }
        return Optional.empty();
    }

    @Override
    public void close() {
        try {
            this.apiClient.httpClient().close();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to close the HTTP client.", e);
        }
    }

    public static void setDefaultBaseUrls(Optional<String> geminiBaseUrl, Optional<String> vertexBaseUrl) {
        Client.geminiBaseUrl = geminiBaseUrl;
        Client.vertexBaseUrl = vertexBaseUrl;
    }

    static Optional<String> inferBaseUrl(boolean vertexAI, Optional<HttpOptions> httpOptions, Optional<Map<String, String>> environmentVariables) {
        if (httpOptions.isPresent() && httpOptions.get().baseUrl().isPresent()) {
            return httpOptions.get().baseUrl();
        }
        if (vertexAI) {
            if (vertexBaseUrl.isPresent()) {
                return vertexBaseUrl;
            }
            if (environmentVariables.isPresent()) {
                return Optional.ofNullable(environmentVariables.get().get("GOOGLE_VERTEX_BASE_URL"));
            }
        } else {
            if (geminiBaseUrl.isPresent()) {
                return geminiBaseUrl;
            }
            if (environmentVariables.isPresent()) {
                return Optional.ofNullable(environmentVariables.get().get("GOOGLE_GEMINI_BASE_URL"));
            }
        }
        return Optional.empty();
    }

    public static class Builder {
        private Optional<String> apiKey = Optional.empty();
        private Optional<String> project = Optional.empty();
        private Optional<String> location = Optional.empty();
        private Optional<GoogleCredentials> credentials = Optional.empty();
        private Optional<HttpOptions> httpOptions = Optional.empty();
        private Optional<Boolean> vertexAI = Optional.empty();
        private Optional<DebugConfig> debugConfig = Optional.empty();
        private Optional<Map<String, String>> environmentVariables = Optional.empty();

        public Client build() {
            return new Client(this.apiKey, this.project, this.location, this.credentials, this.httpOptions, this.vertexAI, this.debugConfig, this.environmentVariables);
        }

        public Builder apiKey(String apiKey) {
            Preconditions.checkNotNull((Object)apiKey, (Object)"apiKey cannot be null");
            this.apiKey = Optional.of(apiKey);
            return this;
        }

        public Builder project(String project) {
            Preconditions.checkNotNull((Object)project, (Object)"project cannot be null");
            this.project = Optional.of(project);
            return this;
        }

        public Builder location(String location) {
            Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
            this.location = Optional.of(location);
            return this;
        }

        public Builder credentials(GoogleCredentials credentials) {
            Preconditions.checkNotNull((Object)credentials, (Object)"credentials cannot be null");
            this.credentials = Optional.of(credentials);
            return this;
        }

        public Builder httpOptions(HttpOptions httpOptions) {
            Preconditions.checkNotNull((Object)httpOptions, (Object)"httpOptions cannot be null");
            this.httpOptions = Optional.of(httpOptions);
            return this;
        }

        public Builder vertexAI(boolean vertexAI) {
            this.vertexAI = Optional.of(vertexAI);
            return this;
        }

        Builder debugConfig(DebugConfig debugConfig) {
            Preconditions.checkNotNull((Object)debugConfig, (Object)"debugConfig cannot be null");
            this.debugConfig = Optional.of(debugConfig);
            return this;
        }

        Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = Optional.of(environmentVariables);
            return this;
        }
    }

    public final class Async {
        public final AsyncModels models;
        public final AsyncCaches caches;
        public final AsyncOperations operations;
        public final AsyncLive live;
        public final AsyncChats chats;
        public final AsyncFiles files;

        public Async(ApiClient apiClient) {
            this.models = new AsyncModels(apiClient);
            this.caches = new AsyncCaches(apiClient);
            this.operations = new AsyncOperations(apiClient);
            this.live = new AsyncLive(apiClient);
            this.files = new AsyncFiles(apiClient);
            this.chats = new AsyncChats(apiClient);
        }
    }
}

