/*
 * Decompiled with CFR 0.152.
 */
package rat.report.analyser;

import java.io.IOException;
import rat.document.IDocument;
import rat.document.IDocumentCollection;
import rat.document.RatDocumentAnalysisException;
import rat.report.analyser.AbstractSingleClaimAnalyser;
import rat.report.claim.IClaimReporter;

public final class ReadableArchiveAnalyser
extends AbstractSingleClaimAnalyser {
    public static final String READABLE_ARCHIVE_VALUE = "readable";
    public static final String UNREADABLE_ARCHIVE_VALUE = "unreadable";

    public ReadableArchiveAnalyser(IClaimReporter reporter) {
        super(reporter, "archive-type", false);
    }

    protected CharSequence toObject(IDocument document) throws RatDocumentAnalysisException {
        boolean readable = false;
        try {
            IDocumentCollection contents = document.readArchive();
            if (contents != null) {
                readable = true;
            }
        }
        catch (IOException e) {
            readable = false;
        }
        String result = UNREADABLE_ARCHIVE_VALUE;
        if (readable) {
            result = READABLE_ARCHIVE_VALUE;
        }
        return result;
    }
}

