/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.DigestOnlyLayer;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.ReferenceLayer;
import com.google.cloud.tools.jib.image.ReferenceNoDiffIdLayer;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import java.util.ArrayList;
import java.util.List;

public class JsonToImageTranslator {
    public static Image<Layer> toImage(V21ManifestTemplate manifestTemplate) throws LayerPropertyNotFoundException {
        Image.Builder<DigestOnlyLayer> imageBuilder = Image.builder();
        for (DescriptorDigest digest : manifestTemplate.getLayerDigests()) {
            imageBuilder.addLayer(new DigestOnlyLayer(digest));
        }
        return imageBuilder.build();
    }

    public static Image<Layer> toImage(BuildableManifestTemplate manifestTemplate, ContainerConfigurationTemplate containerConfigurationTemplate) throws LayerCountMismatchException, LayerPropertyNotFoundException {
        ArrayList<ReferenceNoDiffIdLayer> layers = new ArrayList<ReferenceNoDiffIdLayer>();
        for (BuildableManifestTemplate.ContentDescriptorTemplate layerObjectTemplate : manifestTemplate.getLayers()) {
            if (layerObjectTemplate.getDigest() == null) {
                throw new IllegalArgumentException("All layers in the manifest template must have digest set");
            }
            layers.add(new ReferenceNoDiffIdLayer(new BlobDescriptor(layerObjectTemplate.getSize(), layerObjectTemplate.getDigest())));
        }
        List<DescriptorDigest> diffIds = containerConfigurationTemplate.getDiffIds();
        if (layers.size() != diffIds.size()) {
            throw new LayerCountMismatchException("Mismatch between image manifest and container configuration");
        }
        Image.Builder<ReferenceLayer> imageBuilder = Image.builder();
        for (int layerIndex = 0; layerIndex < layers.size(); ++layerIndex) {
            ReferenceNoDiffIdLayer noDiffIdLayer = (ReferenceNoDiffIdLayer)layers.get(layerIndex);
            DescriptorDigest diffId = diffIds.get(layerIndex);
            imageBuilder.addLayer(new ReferenceLayer(noDiffIdLayer.getBlobDescriptor(), diffId));
        }
        if (containerConfigurationTemplate.getContainerEntrypoint() != null) {
            imageBuilder.setEntrypoint(containerConfigurationTemplate.getContainerEntrypoint());
        }
        if (containerConfigurationTemplate.getContainerCmd() != null) {
            imageBuilder.setJavaArguments(containerConfigurationTemplate.getContainerCmd());
        }
        if (containerConfigurationTemplate.getContainerEnvironment() != null) {
            for (String environmentVariable : containerConfigurationTemplate.getContainerEnvironment()) {
                imageBuilder.addEnvironmentVariableDefinition(environmentVariable);
            }
        }
        return imageBuilder.build();
    }

    private JsonToImageTranslator() {
    }
}

