/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.interceptor.pagination;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.ParameterUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserGlobal;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import com.github.yulichang.interceptor.pagination.DialectWrapper;
import com.github.yulichang.interceptor.pagination.ParseHelper;
import com.github.yulichang.wrapper.interfaces.SelectWrapper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class PageInnerInterceptorWrapper
extends PaginationInnerInterceptor {
    private static final Log log = LogFactory.getLog(PageInnerInterceptorWrapper.class);
    private final PaginationInnerInterceptor paginationInnerInterceptor;

    public PageInnerInterceptorWrapper(PaginationInnerInterceptor pagination) {
        this.paginationInnerInterceptor = pagination;
        super.setOptimizeJoin(true);
        super.setDbType(pagination.getDbType());
        super.setDialect(pagination.getDialect());
        super.setOverflow(pagination.isOverflow());
        super.setMaxLimit(pagination.getMaxLimit());
    }

    public boolean willDoQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        Object o;
        BoundSql countSql;
        if (this.unusedPage(parameter)) {
            return this.paginationInnerInterceptor.willDoQuery(executor, ms, parameter, rowBounds, resultHandler, boundSql);
        }
        SelectWrapper<?, ?> wrapper = PageInnerInterceptorWrapper.findMPJWrapper(parameter).orElseThrow(RuntimeException::new);
        IPage page = ParameterUtils.findPage((Object)parameter).orElse(null);
        if (page == null || page.getSize() < 0L || !page.searchCount() || resultHandler != Executor.NO_RESULT_HANDLER) {
            return true;
        }
        MappedStatement countMs = this.buildCountMappedStatement(ms, page.countId());
        if (countMs != null) {
            countSql = countMs.getBoundSql(parameter);
        } else {
            countMs = this.buildAutoCountMappedStatement(ms);
            ArrayList<ParameterMapping> mappingArrayList = new ArrayList<ParameterMapping>(boundSql.getParameterMappings());
            String countSqlStr = this.autoCountSql(boundSql.getSql(), mappingArrayList, ms, parameter, wrapper);
            PluginUtils.MPBoundSql mpBoundSql = PluginUtils.mpBoundSql((BoundSql)boundSql);
            countSql = new BoundSql(countMs.getConfiguration(), countSqlStr, mappingArrayList, parameter);
            PluginUtils.setAdditionalParameter((BoundSql)countSql, (Map)mpBoundSql.additionalParameters());
        }
        CacheKey cacheKey = executor.createCacheKey(countMs, parameter, rowBounds, countSql);
        List result = executor.query(countMs, parameter, rowBounds, resultHandler, cacheKey, countSql);
        long total = 0L;
        if (CollectionUtils.isNotEmpty((Collection)result) && (o = result.get(0)) != null) {
            total = Long.parseLong(o.toString());
        }
        page.setTotal(total);
        return this.continuePage(page);
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        Long _limit;
        if (this.unusedPage(parameter)) {
            this.paginationInnerInterceptor.beforeQuery(executor, ms, parameter, rowBounds, resultHandler, boundSql);
            return;
        }
        IPage page = ParameterUtils.findPage((Object)parameter).orElse(null);
        if (null == page) {
            return;
        }
        boolean addOrdered = false;
        String buildSql = boundSql.getSql();
        List orders = page.orders();
        if (CollectionUtils.isNotEmpty((Collection)orders)) {
            addOrdered = true;
            buildSql = this.concatOrderBy(buildSql, orders);
        }
        Long l = _limit = page.maxLimit() != null ? page.maxLimit() : this.maxLimit;
        if (page.getSize() < 0L && null == _limit) {
            if (addOrdered) {
                PluginUtils.mpBoundSql((BoundSql)boundSql).sql(buildSql);
            }
            return;
        }
        this.handlerLimit(page, _limit);
        DialectWrapper dialect = this.findMPJDialect(executor);
        Configuration configuration = ms.getConfiguration();
        PluginUtils.MPBoundSql mpBoundSql = PluginUtils.mpBoundSql((BoundSql)boundSql);
        Map additionalParameter = mpBoundSql.additionalParameters();
        dialect.buildPaginationSql(buildSql, boundSql.getParameterMappings(), page.offset(), page.getSize(), c -> c.consumers(dialect.getPageMappings(), configuration, additionalParameter), ms, parameter);
        mpBoundSql.sql(dialect.getFinallySql());
        mpBoundSql.parameterMappings(dialect.getFullMappings());
    }

    private boolean unusedPage(Object parameter) {
        return PageInnerInterceptorWrapper.findMPJWrapper(parameter).map(SelectWrapper::isPageByMain).orElse(false) == false;
    }

    private String autoCountSql(String sql, List<ParameterMapping> mappings, MappedStatement ms, Object parameter, SelectWrapper<?, ?> wrapper) {
        try {
            String repSql;
            List joins;
            String formatSql;
            Select select = (Select)JsqlParserGlobal.parse((String)sql);
            if (select instanceof SetOperationList) {
                throw ExceptionUtils.mpe((String)"\u4e0d\u652f\u6301 union \u5bf9\u591a\u5206\u9875", (Object[])new Object[0]);
            }
            String sourceSql = select.toString();
            int count = ParseHelper.countChar(sourceSql);
            if (count == mappings.size()) {
                formatSql = ParseHelper.decode(sourceSql);
            } else {
                SqlSource sqlSource = ms.getSqlSource();
                if (sqlSource instanceof DynamicSqlSource) {
                    formatSql = ParseHelper.getOriginalSql(parameter, (DynamicSqlSource)sqlSource);
                } else {
                    log.error((Object)("unknown type: " + sqlSource.getClass().getName()));
                    throw ExceptionUtils.mpe((String)("not support this sql, please use xml. error sql: " + sql), (Object[])new Object[0]);
                }
            }
            PlainSelect ps = (PlainSelect)JsqlParserGlobal.parse((String)formatSql);
            List orderBy = ps.getOrderByElements();
            if (CollectionUtils.isNotEmpty((Collection)orderBy)) {
                boolean canClean = true;
                for (OrderByElement order : orderBy) {
                    Expression expression = order.getExpression();
                    if (expression instanceof Column || !expression.toString().contains("?")) continue;
                    canClean = false;
                    break;
                }
                if (canClean) {
                    ps.setOrderByElements(null);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(joins = ps.getJoins()))) {
                ps.setJoins(null);
            }
            Distinct distinct = ps.getDistinct();
            GroupByElement groupBy = ps.getGroupBy();
            String mainAlias = Optional.of(ps.getFromItem().getAlias().getName()).orElse("");
            if (null != distinct || null != groupBy) {
                if (wrapper.getPageInfo().getCountSelectSql() != null) {
                    ps.setSelectItems(Collections.singletonList(new SelectItem((Expression)new Column().withColumnName(wrapper.getPageInfo().getCountSelectSql()))));
                } else {
                    ps.getSelectItems().removeIf(s -> {
                        if (s.getExpression() instanceof Column) {
                            Column column = (Column)s.getExpression();
                            return !mainAlias.equals(column.getTable().toString());
                        }
                        return false;
                    });
                }
                repSql = this.lowLevelCountSql(ps.toString());
            } else {
                ps.setSelectItems(COUNT_SELECT_ITEM);
                repSql = ps.toString();
            }
            HashMap<Integer, ParameterMapping> sortMap = new HashMap<Integer, ParameterMapping>();
            repSql = ParseHelper.encode(mappings, count, repSql, sortMap);
            mappings.clear();
            mappings.addAll(sortMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList()));
            return repSql;
        }
        catch (JSQLParserException e) {
            this.logger.error("optimize this sql to a count sql has exception, sql:\"" + sql + "\", exception:\n" + e.getCause());
        }
        catch (Exception e) {
            this.logger.error("optimize this sql to a count sql has error, sql:\"" + sql + "\", exception:\n" + e);
        }
        throw ExceptionUtils.mpe((String)("not support this sql, please use xml. error sql: " + sql), (Object[])new Object[0]);
    }

    private DialectWrapper findMPJDialect(Executor executor) {
        IDialect dialect = super.findIDialect(executor);
        return new DialectWrapper(dialect);
    }

    private static Optional<SelectWrapper<?, ?>> findMPJWrapper(Object parameterObject) {
        if (parameterObject != null) {
            if (parameterObject instanceof Map) {
                Map parameterMap = (Map)parameterObject;
                for (Map.Entry entry : parameterMap.entrySet()) {
                    if (entry.getValue() == null || !(entry.getValue() instanceof SelectWrapper)) continue;
                    return Optional.of((SelectWrapper)entry.getValue());
                }
            } else if (parameterObject instanceof SelectWrapper) {
                return Optional.of((SelectWrapper)parameterObject);
            }
        }
        return Optional.empty();
    }
}

