/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.query;

import com.baomidou.mybatisplus.core.conditions.AbstractLambdaWrapper;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.query.Query;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.query.MPJQueryWrapper;
import com.github.yulichang.query.interfaces.CompareIfAbsent;
import com.github.yulichang.query.interfaces.StringJoin;
import com.github.yulichang.toolkit.Asserts;
import com.github.yulichang.toolkit.TableHelper;
import com.github.yulichang.toolkit.ThrowOptional;
import com.github.yulichang.wrapper.enums.IfAbsentSqlKeyWordEnum;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MPJLambdaQueryWrapper<T>
extends AbstractLambdaWrapper<T, MPJLambdaQueryWrapper<T>>
implements Query<MPJLambdaQueryWrapper<T>, T, SFunction<T, ?>>,
StringJoin<MPJLambdaQueryWrapper<T>, T>,
CompareIfAbsent<MPJLambdaQueryWrapper<T>, SFunction<T, ?>> {
    private SharedString sqlSelect = new SharedString();
    private SharedString from = SharedString.emptyString();
    private String alias = ConfigProperties.tableAlias;
    private List<String> selectColumns = new ArrayList<String>();
    private List<String> ignoreColumns = new ArrayList<String>();
    private boolean selectDistinct = false;
    private boolean logicSql = true;
    private Function<String, String> tableNameFunc;
    private BiPredicate<Object, IfAbsentSqlKeyWordEnum> ifAbsent = ConfigProperties.ifAbsent;

    public MPJLambdaQueryWrapper() {
    }

    MPJLambdaQueryWrapper(T entity, Class<T> entityClass, SharedString from, SharedString sqlSelect, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst, List<String> selectColumns, List<String> ignoreColumns, boolean selectDistinct, BiPredicate<Object, IfAbsentSqlKeyWordEnum> ifAbsent) {
        super.setEntity(entity);
        this.setEntityClass(entityClass);
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.sqlSelect = sqlSelect;
        this.from = from;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        ThrowOptional.tryDo(() -> {
            this.sqlFirst = sqlFirst;
        }).catchDo();
        this.selectColumns = selectColumns;
        this.ignoreColumns = ignoreColumns;
        this.selectDistinct = selectDistinct;
        this.ifAbsent = ifAbsent;
    }

    @SafeVarargs
    public final MPJLambdaQueryWrapper<T> select(SFunction<T, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            for (SFunction<T, ?> s : columns) {
                this.selectColumns.add(this.columnToString(s, false));
            }
        }
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    public MPJLambdaQueryWrapper<T> select(boolean condition, List<SFunction<T, ?>> columns) {
        if (condition && CollectionUtils.isNotEmpty(columns)) {
            for (SFunction<T, ?> s : columns) {
                this.selectColumns.add(this.columnToString(s, false));
            }
        }
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    public MPJLambdaQueryWrapper<T> selectIgnore(String ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            this.ignoreColumns.addAll(Arrays.asList(columns));
        }
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    @SafeVarargs
    public final MPJLambdaQueryWrapper<T> selectIgnore(SFunction<T, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            for (SFunction<T, ?> s : columns) {
                this.ignoreColumns.add(this.alias + "." + this.columnToString(s));
            }
        }
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    protected String columnToString(SFunction<T, ?> column, boolean onlyColumn) {
        return this.alias + "." + super.columnToString(column, onlyColumn);
    }

    public MPJLambdaQueryWrapper<T> select(String ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            Collections.addAll(this.selectColumns, columns);
        }
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    public MPJLambdaQueryWrapper<T> select(Class<T> entityClass, Predicate<TableFieldInfo> predicate) {
        TableInfo info = TableHelper.get(entityClass);
        Asserts.hasTable(info, entityClass);
        this.selectColumns.addAll(info.getFieldList().stream().filter(predicate).map(c -> this.alias + "." + c.getColumn()).collect(Collectors.toList()));
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    public final MPJLambdaQueryWrapper<T> selectAll(Class<T> clazz) {
        return this.selectAll(clazz, this.alias);
    }

    public final MPJLambdaQueryWrapper<T> selectAll(Class<?> clazz, String as) {
        TableInfo info = TableHelper.get(clazz);
        Asserts.hasTable(info, clazz);
        if (info.havePK()) {
            this.selectColumns.add(as + "." + info.getKeyColumn());
        }
        this.selectColumns.addAll(info.getFieldList().stream().map(i -> as + "." + i.getColumn()).collect(Collectors.toList()));
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    public MPJQueryWrapper<T> stringQuery() {
        return new MPJQueryWrapper<Object>(this.getEntity(), this.getEntityClass(), this.paramNameSeq, this.paramNameValuePairs, this.expression, this.sqlSelect, this.from, this.lastSql, this.sqlComment, this.sqlFirst, this.selectColumns, this.ignoreColumns, this.selectDistinct, this.ifAbsent);
    }

    public String getSqlSelect() {
        if (StringUtils.isBlank((CharSequence)this.sqlSelect.getStringValue())) {
            if (CollectionUtils.isNotEmpty(this.ignoreColumns)) {
                this.selectColumns.removeIf(this.ignoreColumns::contains);
            }
            this.sqlSelect.setStringValue(String.join((CharSequence)",", this.selectColumns));
        }
        return this.sqlSelect.getStringValue();
    }

    public MPJLambdaQueryWrapper<T> distinct() {
        this.selectDistinct = true;
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    public String getFrom() {
        return this.from.getStringValue();
    }

    public MPJLambdaQueryWrapper<T> setAlias(String alias) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)alias), (String)"\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.alias = alias;
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    public String getSubLogicSql() {
        return "";
    }

    public MPJLambdaQueryWrapper<T> disableLogicDel() {
        this.logicSql = false;
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    public MPJLambdaQueryWrapper<T> enableLogicDel() {
        this.logicSql = true;
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    public boolean getLogicSql() {
        return this.logicSql;
    }

    public boolean getSelectDistinct() {
        return this.selectDistinct;
    }

    public MPJLambdaQueryWrapper<T> setTableName(Function<String, String> func) {
        this.tableNameFunc = func;
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    public String getTableName(String tableName) {
        if (this.tableNameFunc == null) {
            return tableName;
        }
        return this.tableNameFunc.apply(tableName);
    }

    public String getTableNameEnc(String tableName) {
        String decode;
        try {
            decode = URLDecoder.decode(tableName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            decode = tableName;
        }
        if (this.tableNameFunc == null) {
            return decode;
        }
        return this.tableNameFunc.apply(decode);
    }

    public MPJLambdaQueryWrapper<T> setIfAbsent(BiPredicate<Object, IfAbsentSqlKeyWordEnum> ifAbsent) {
        this.ifAbsent = ifAbsent;
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    public MPJLambdaQueryWrapper<T> setIfAbsent(Predicate<Object> ifAbsent) {
        this.ifAbsent = (o, k) -> ifAbsent.test(o);
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    protected MPJLambdaQueryWrapper<T> instance() {
        return new MPJLambdaQueryWrapper<Object>(this.getEntity(), this.getEntityClass(), null, null, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString(), null, null, this.selectDistinct, this.ifAbsent);
    }

    public Class<T> getEntityClass() {
        try {
            return super.getEntityClass();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public MPJLambdaQueryWrapper<T> setEntityClass(Class<T> entityClass) {
        try {
            return (MPJLambdaQueryWrapper)super.setEntityClass(entityClass);
        }
        catch (Throwable throwable) {
            return this;
        }
    }

    public SharedString getSqlFirstField() {
        try {
            return this.sqlSelect;
        }
        catch (Throwable throwable) {
            return SharedString.emptyString();
        }
    }

    public void clear() {
        super.clear();
        this.sqlSelect.toNull();
        this.from.toNull();
        this.selectColumns.clear();
        this.ignoreColumns.clear();
        this.ifAbsent = ConfigProperties.ifAbsent;
    }

    @Override
    public MPJLambdaQueryWrapper<T> join(String keyWord, boolean condition, String joinSql) {
        if (condition) {
            this.from.setStringValue(this.from.getStringValue() + keyWord + joinSql);
        }
        return (MPJLambdaQueryWrapper)this.typedThis;
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public BiPredicate<Object, IfAbsentSqlKeyWordEnum> getIfAbsent() {
        return this.ifAbsent;
    }
}

