// Copyright 2021 Tencent Inc. All rights reserved.
//
// 商家转账对外API
//
// * 场景及业务流程：     商户可通过该产品实现同时向多个用户微信零钱进行转账的操作，可用于发放奖金补贴、佣金货款结算、员工报销等场景。
// [https://pay.weixin.qq.com/index.php/public/product/detail?pid=108&productType=0](https://pay.weixin.qq.com/index.php/public/product/detail?pid=108&productType=0) * 接入步骤：     * 商户在微信支付商户平台开通“批量转账到零钱”产品权限，并勾选“使用API方式发起转账”。     * 调用批量转账接口，对多个用户微信零钱发起转账。     * 调用查询批次接口，可获取到转账批次详情及当前状态。     * 调用查询明细接口，可获取到单条转账明细详情及当前状态。
//
// API version: 1.0.5

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.transferbatch.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import com.wechat.pay.java.core.cipher.Encryption;
import java.util.function.UnaryOperator;

/** TransferDetailEntity */
public class TransferDetailEntity {
  /** 商户号 说明：微信支付分配的商户号 */
  @SerializedName("mchid")
  private String mchid;

  /** 商家批次单号 说明：商户系统内部的商家批次单号，在商户系统内部唯一 */
  @SerializedName("out_batch_no")
  private String outBatchNo;

  /** 微信批次单号 说明：微信批次单号，微信商家转账系统返回的唯一标识 */
  @SerializedName("batch_id")
  private String batchId;

  /** 商户appid 说明：申请商户号的appid或商户号绑定的appid（企业号corpid即为此appid） */
  @SerializedName("appid")
  private String appid;

  /** 商家明细单号 说明：商户系统内部区分转账批次单下不同转账明细单的唯一标识 */
  @SerializedName("out_detail_no")
  private String outDetailNo;

  /** 微信明细单号 说明：微信支付系统内部区分转账批次单下不同转账明细单的唯一标识 */
  @SerializedName("detail_id")
  private String detailId;

  /**
   * 明细状态 说明：INIT: 初始态。 系统转账校验中 WAIT_PAY: 待确认。待商户确认, 符合免密条件时, 系统会自动扭转为转账中
   * PROCESSING:转账中。正在处理中，转账结果尚未明确 SUCCESS:转账成功 FAIL:转账失败。需要确认失败原因后，再决定是否重新发起对该笔明细单的转账（并非整个转账批次单）
   */
  @SerializedName("detail_status")
  private String detailStatus;

  /** 转账金额 说明：转账金额单位为“分” */
  @SerializedName("transfer_amount")
  private Long transferAmount;

  /** 转账备注 说明：单条转账备注（微信用户会收到该备注），UTF8编码，最多允许32个字符 */
  @SerializedName("transfer_remark")
  private String transferRemark;

  /** 明细失败原因 说明：如果转账失败则有失败原因 */
  @SerializedName("fail_reason")
  private FailReasonType failReason;

  /** 收款用户openid 说明：商户appid下，某用户的openid */
  @SerializedName("openid")
  private String openid;

  /** 收款用户姓名 说明：收款方姓名。采用标准RSA算法，公钥由微信侧提供 商户转账时传入了收款用户姓名、查询时会返回收款用户姓名 */
  @Encryption
  @SerializedName("user_name")
  private String userName;

  /** 转账发起时间 说明：转账发起的时间，按照使用rfc3339所定义的格式，格式为YYYY-MM-DDThh:mm:ss+TIMEZONE */
  @SerializedName("initiate_time")
  private String initiateTime;

  /** 明细更新时间 说明：明细最后一次状态变更的时间，按照使用rfc3339所定义的格式，格式为YYYY-MM-DDThh:mm:ss+TIMEZONE */
  @SerializedName("update_time")
  private String updateTime;

  public String getMchid() {
    return mchid;
  }

  public void setMchid(String mchid) {
    this.mchid = mchid;
  }

  public String getOutBatchNo() {
    return outBatchNo;
  }

  public void setOutBatchNo(String outBatchNo) {
    this.outBatchNo = outBatchNo;
  }

  public String getBatchId() {
    return batchId;
  }

  public void setBatchId(String batchId) {
    this.batchId = batchId;
  }

  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public String getOutDetailNo() {
    return outDetailNo;
  }

  public void setOutDetailNo(String outDetailNo) {
    this.outDetailNo = outDetailNo;
  }

  public String getDetailId() {
    return detailId;
  }

  public void setDetailId(String detailId) {
    this.detailId = detailId;
  }

  public String getDetailStatus() {
    return detailStatus;
  }

  public void setDetailStatus(String detailStatus) {
    this.detailStatus = detailStatus;
  }

  public Long getTransferAmount() {
    return transferAmount;
  }

  public void setTransferAmount(Long transferAmount) {
    this.transferAmount = transferAmount;
  }

  public String getTransferRemark() {
    return transferRemark;
  }

  public void setTransferRemark(String transferRemark) {
    this.transferRemark = transferRemark;
  }

  public FailReasonType getFailReason() {
    return failReason;
  }

  public void setFailReason(FailReasonType failReason) {
    this.failReason = failReason;
  }

  public String getOpenid() {
    return openid;
  }

  public void setOpenid(String openid) {
    this.openid = openid;
  }

  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  public String getInitiateTime() {
    return initiateTime;
  }

  public void setInitiateTime(String initiateTime) {
    this.initiateTime = initiateTime;
  }

  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferDetailEntity {\n");
    sb.append("    mchid: ").append(toIndentedString(mchid)).append("\n");
    sb.append("    outBatchNo: ").append(toIndentedString(outBatchNo)).append("\n");
    sb.append("    batchId: ").append(toIndentedString(batchId)).append("\n");
    sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
    sb.append("    outDetailNo: ").append(toIndentedString(outDetailNo)).append("\n");
    sb.append("    detailId: ").append(toIndentedString(detailId)).append("\n");
    sb.append("    detailStatus: ").append(toIndentedString(detailStatus)).append("\n");
    sb.append("    transferAmount: ").append(toIndentedString(transferAmount)).append("\n");
    sb.append("    transferRemark: ").append(toIndentedString(transferRemark)).append("\n");
    sb.append("    failReason: ").append(toIndentedString(failReason)).append("\n");
    sb.append("    openid: ").append(toIndentedString(openid)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    initiateTime: ").append(toIndentedString(initiateTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public TransferDetailEntity cloneWithCipher(UnaryOperator<String> s) {
    TransferDetailEntity copy = new TransferDetailEntity();
    copy.mchid = mchid;
    copy.outBatchNo = outBatchNo;
    copy.batchId = batchId;
    copy.appid = appid;
    copy.outDetailNo = outDetailNo;
    copy.detailId = detailId;
    copy.detailStatus = detailStatus;
    copy.transferAmount = transferAmount;
    copy.transferRemark = transferRemark;
    copy.failReason = failReason;
    copy.openid = openid;
    if (userName != null && !userName.isEmpty()) {
      copy.userName = s.apply(userName);
    }
    copy.initiateTime = initiateTime;
    copy.updateTime = updateTime;
    return copy;
  }
}
