// Copyright 2021 Tencent Inc. All rights reserved.
//
// 营销加价购对外API
//
// 指定服务商可通过该接口报名加价购活动、查询某个区域内的加价购活动列表、锁定加价活动购资格以及解锁加价购活动资格。
//
// API version: 1.4.0

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.retailstore.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** ActInfo */
public class ActInfo {
  /** 活动名称 说明：活动名称 */
  @SerializedName("activity_name")
  private String activityName;

  /**
   * 活动报名开始时间
   * 说明：遵循rfc3339标准格式，格式为YYYY-MM-DDTHH:mm:ss+TIMEZONE，YYYY-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）
   */
  @SerializedName("apply_start_time")
  private String applyStartTime;

  /**
   * 活动报名结束时间
   * 说明：遵循rfc3339标准格式，格式为YYYY-MM-DDTHH:mm:ss+TIMEZONE，YYYY-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）
   */
  @SerializedName("apply_end_time")
  private String applyEndTime;

  /**
   * 活动开始时间
   * 说明：遵循rfc3339标准格式，格式为YYYY-MM-DDTHH:mm:ss+TIMEZONE，YYYY-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）
   */
  @SerializedName("activity_start_time")
  private String activityStartTime;

  /**
   * 活动结束时间
   * 说明：遵循rfc3339标准格式，格式为YYYY-MM-DDTHH:mm:ss+TIMEZONE，YYYY-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）
   */
  @SerializedName("activity_end_time")
  private String activityEndTime;

  /** 活动描述 说明：活动描述 */
  @SerializedName("activity_description")
  private String activityDescription;

  public String getActivityName() {
    return activityName;
  }

  public void setActivityName(String activityName) {
    this.activityName = activityName;
  }

  public String getApplyStartTime() {
    return applyStartTime;
  }

  public void setApplyStartTime(String applyStartTime) {
    this.applyStartTime = applyStartTime;
  }

  public String getApplyEndTime() {
    return applyEndTime;
  }

  public void setApplyEndTime(String applyEndTime) {
    this.applyEndTime = applyEndTime;
  }

  public String getActivityStartTime() {
    return activityStartTime;
  }

  public void setActivityStartTime(String activityStartTime) {
    this.activityStartTime = activityStartTime;
  }

  public String getActivityEndTime() {
    return activityEndTime;
  }

  public void setActivityEndTime(String activityEndTime) {
    this.activityEndTime = activityEndTime;
  }

  public String getActivityDescription() {
    return activityDescription;
  }

  public void setActivityDescription(String activityDescription) {
    this.activityDescription = activityDescription;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActInfo {\n");
    sb.append("    activityName: ").append(toIndentedString(activityName)).append("\n");
    sb.append("    applyStartTime: ").append(toIndentedString(applyStartTime)).append("\n");
    sb.append("    applyEndTime: ").append(toIndentedString(applyEndTime)).append("\n");
    sb.append("    activityStartTime: ").append(toIndentedString(activityStartTime)).append("\n");
    sb.append("    activityEndTime: ").append(toIndentedString(activityEndTime)).append("\n");
    sb.append("    activityDescription: ")
        .append(toIndentedString(activityDescription))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }
}
