// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微工卡接口文档
//
// 服务商通过本API文档提供的接口，查询商户和微工卡的授权关系、生成预授权的token口令、核身预下单、核身结果的查询等。
//
// API version: 1.5.2

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.payrollcard.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/** ListAuthenticationsRequest */
public class ListAuthenticationsRequest {
  /** 用户OpenID 说明：微信用户OpenID */
  @SerializedName("openid")
  @Expose(serialize = false)
  private String openid;

  /** 服务商AppID 说明：当输入服务商AppID时会校验其与服务商商户号绑定关系。 服务商AppID和特约商户AppID至少输入一个。 */
  @SerializedName("appid")
  @Expose(serialize = false)
  private String appid;

  /** 特约商户AppID 说明：当输入特约商户AppID时会校验其与特约商户号关系。 特约商户AppID和服务商AppID至少输入一个。 */
  @SerializedName("sub_appid")
  @Expose(serialize = false)
  private String subAppid;

  /** 特约商户号 说明：特约商户号 */
  @SerializedName("sub_mchid")
  @Expose(serialize = false)
  private String subMchid;

  /** 核身日期 说明：核身日期，一次只能查询一天，最久可查询90天内的记录，格式为“yyyy-MM-DD” */
  @SerializedName("authenticate_date")
  @Expose(serialize = false)
  private String authenticateDate;

  /** 核身状态 说明：核身状态，列表查询仅提供成功状态的核身记录查询，故此字段固定默认值即可 */
  @SerializedName("authenticate_state")
  @Expose(serialize = false)
  private String authenticateState;

  /** 本次查询偏移量 说明：非负整数，表示该次请求资源的起始位置，从0开始计数。调用方选填，默认为0。offset为10，limit为10时，查询第10-19条数据 */
  @SerializedName("offset")
  @Expose(serialize = false)
  private Long offset;

  /** 本次请求最大查询条数 说明：非0非负的整数，该次请求可返回的最大资源条数，默认值为10，最大支持10条。 */
  @SerializedName("limit")
  @Expose(serialize = false)
  private Long limit;

  public String getOpenid() {
    return openid;
  }

  public void setOpenid(String openid) {
    this.openid = openid;
  }

  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public String getSubAppid() {
    return subAppid;
  }

  public void setSubAppid(String subAppid) {
    this.subAppid = subAppid;
  }

  public String getSubMchid() {
    return subMchid;
  }

  public void setSubMchid(String subMchid) {
    this.subMchid = subMchid;
  }

  public String getAuthenticateDate() {
    return authenticateDate;
  }

  public void setAuthenticateDate(String authenticateDate) {
    this.authenticateDate = authenticateDate;
  }

  public String getAuthenticateState() {
    return authenticateState;
  }

  public void setAuthenticateState(String authenticateState) {
    this.authenticateState = authenticateState;
  }

  public Long getOffset() {
    return offset;
  }

  public void setOffset(Long offset) {
    this.offset = offset;
  }

  public Long getLimit() {
    return limit;
  }

  public void setLimit(Long limit) {
    this.limit = limit;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ListAuthenticationsRequest {\n");
    sb.append("    openid: ").append(toIndentedString(openid)).append("\n");
    sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
    sb.append("    subAppid: ").append(toIndentedString(subAppid)).append("\n");
    sb.append("    subMchid: ").append(toIndentedString(subMchid)).append("\n");
    sb.append("    authenticateDate: ").append(toIndentedString(authenticateDate)).append("\n");
    sb.append("    authenticateState: ").append(toIndentedString(authenticateState)).append("\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
