// Copyright 2021 Tencent Inc. All rights reserved.
//
// 营销商家券对外API
//
// No description provided (generated by Openapi Generator
// https://github.com/openapitools/openapi-generator)
//
// API version: 0.0.11

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.merchantexclusivecoupon.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** DisplayPatternInfo */
public class DisplayPatternInfo {
  /** 使用须知 说明：用于说明详细的活动规则，会展示在代金券详情页。 */
  @SerializedName("description")
  private String description;

  /**
   * 商户logo
   * 说明：若券归属商户号有认证品牌，则系统将自动拉取对应品牌logo；若券归属商户号不在认证品牌下，需自定义上传logo，未上传时将展示兜底灰色logo样式，影响券详情页用户体验，请及时上传。
   * 商户logo的URL地址，仅支持通过《[图片上传API](https://pay.weixin.qq.com/wiki/doc/apiv3/apis/chapter9_0_1.shtml)》接口获取的图片URL地址。
   * 1、商户logo大小需为120像素\\*120像素。 2、支持JPG/JPEG/PNG格式，且图片小于1M。 注：该字段暂不支持修改
   */
  @SerializedName("merchant_logo_url")
  private String merchantLogoUrl;

  /**
   * 商户名称 说明：不支持商户自定义。若券归属商户号有认证品牌，系统将自动拉取认证品牌号下的品牌名称；若券归属商户号不在认证品牌下，则拉取本商户号的商户简称。展示上限12个字符。
   * 注：该字段暂不支持修改
   */
  @SerializedName("merchant_name")
  private String merchantName;

  /**
   * 背景颜色
   * 说明：券的背景颜色，可设置10种颜色，色值请参考[卡券背景颜色图](https://pay.weixin.qq.com/wiki/doc/apiv3/apis/chapter9_2_1.shtml#part-01)。颜色取值为颜色图中的颜色名称。
   */
  @SerializedName("background_color")
  private String backgroundColor;

  /**
   * 券详情图片
   * 说明：券详情图片，1074像素（宽）\\*603像素（高），图片大小不超过2M，支持JPG/PNG格式。仅支持通过《[图片上传API](https://pay.weixin.qq.com/wiki/doc/apiv3/apis/chapter9_0_1.shtml)》接口获取的图片URL地址。
   */
  @SerializedName("coupon_image_url")
  private String couponImageUrl;

  /** 视频号相关信息 说明：视频号相关信息 */
  @SerializedName("finder_info")
  private FinderInfo finderInfo;

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getMerchantLogoUrl() {
    return merchantLogoUrl;
  }

  public void setMerchantLogoUrl(String merchantLogoUrl) {
    this.merchantLogoUrl = merchantLogoUrl;
  }

  public String getMerchantName() {
    return merchantName;
  }

  public void setMerchantName(String merchantName) {
    this.merchantName = merchantName;
  }

  public String getBackgroundColor() {
    return backgroundColor;
  }

  public void setBackgroundColor(String backgroundColor) {
    this.backgroundColor = backgroundColor;
  }

  public String getCouponImageUrl() {
    return couponImageUrl;
  }

  public void setCouponImageUrl(String couponImageUrl) {
    this.couponImageUrl = couponImageUrl;
  }

  public FinderInfo getFinderInfo() {
    return finderInfo;
  }

  public void setFinderInfo(FinderInfo finderInfo) {
    this.finderInfo = finderInfo;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DisplayPatternInfo {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    merchantLogoUrl: ").append(toIndentedString(merchantLogoUrl)).append("\n");
    sb.append("    merchantName: ").append(toIndentedString(merchantName)).append("\n");
    sb.append("    backgroundColor: ").append(toIndentedString(backgroundColor)).append("\n");
    sb.append("    couponImageUrl: ").append(toIndentedString(couponImageUrl)).append("\n");
    sb.append("    finderInfo: ").append(toIndentedString(finderInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
