// Copyright 2021 Tencent Inc. All rights reserved.
//
// 银行营销对外API
//
// # 前言
// 银行营销API是专为银行商户设置的一套API。目前仅包含“创建快捷交易协议号上传任务”接口，供银行上传快捷交易协议号文件。微信侧收到文件中，将快捷交易协议号转换为微信用户id，存储到指定的号码包文件中。
//
// API version: 0.1.0

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.marketingbankpackages.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** Task */
public class Task {
  /** 上传任务 说明：上传任务的主键，唯一定义此资源的标识 */
  @SerializedName("task_id")
  private String taskId;

  /** 号码包id 说明：号码包唯一标识符。可在微信支付商户平台创建号码包后获得。 */
  @SerializedName("package_id")
  private String packageId;

  /** 文件名 说明：任务上传的文件名 */
  @SerializedName("filename")
  private String filename;

  /**
   * 创建上传任务的时间
   * 说明：时间格式采用遵循rfc3339标准格式，格式为YYYY-MM-DDTHH:mm:ss+TIMEZONE，YYYY-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35.+08:00表示，北京时间2015年5月20日 13点29分35秒。
   */
  @SerializedName("create_time")
  private String createTime;

  /**
   * 上传任务最近一次更新的时间
   * 说明：时间格式采用遵循rfc3339标准格式，格式为YYYY-MM-DDTHH:mm:ss+TIMEZONE，YYYY-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35.+08:00表示，北京时间2015年5月20日 13点29分35秒。
   */
  @SerializedName("update_time")
  private String updateTime;

  /** 成功数 说明：匹配成功的协议号数。仅当任务状态是FINISHED时，该数据才有效 */
  @SerializedName("success_count")
  private Long successCount;

  /** 失败数 说明：匹配失败的协议号数。仅当任务状态是FINISHED时，该数据才有效 */
  @SerializedName("fail_count")
  private Long failCount;

  /**
   * 匹配成功的微信用户数
   * 说明：匹配成功的微信用户数，不小于匹配成功的协议号数。当一张银行卡被用户绑定到不同微信号时，才可能出现一个协议号对应多个微信账户的情况。仅当任务状态是FINISHED时，该数据才有效
   */
  @SerializedName("success_user_count")
  private Long successUserCount;

  /**
   * 银行类型
   * 说明：银行类型，用于标识协议号所属的银行以及卡类型(信用卡或借记卡)。采用字符串类型的银行标识，值列表详见[银行类型](https://pay.weixin.qq.com/wiki/doc/apiv3_partner/terms_definition/chapter1_1_3.shtml#part-7)
   */
  @SerializedName("bank_type")
  private String bankType;

  /** 任务状态 说明：上传任务的状态：PROCESSING - 处理中，FINISHED - 已完成 */
  @SerializedName("status")
  private TaskStatus status;

  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  public String getPackageId() {
    return packageId;
  }

  public void setPackageId(String packageId) {
    this.packageId = packageId;
  }

  public String getFilename() {
    return filename;
  }

  public void setFilename(String filename) {
    this.filename = filename;
  }

  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  public Long getSuccessCount() {
    return successCount;
  }

  public void setSuccessCount(Long successCount) {
    this.successCount = successCount;
  }

  public Long getFailCount() {
    return failCount;
  }

  public void setFailCount(Long failCount) {
    this.failCount = failCount;
  }

  public Long getSuccessUserCount() {
    return successUserCount;
  }

  public void setSuccessUserCount(Long successUserCount) {
    this.successUserCount = successUserCount;
  }

  public String getBankType() {
    return bankType;
  }

  public void setBankType(String bankType) {
    this.bankType = bankType;
  }

  public TaskStatus getStatus() {
    return status;
  }

  public void setStatus(TaskStatus status) {
    this.status = status;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Task {\n");
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("    packageId: ").append(toIndentedString(packageId)).append("\n");
    sb.append("    filename: ").append(toIndentedString(filename)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    successCount: ").append(toIndentedString(successCount)).append("\n");
    sb.append("    failCount: ").append(toIndentedString(failCount)).append("\n");
    sb.append("    successUserCount: ").append(toIndentedString(successUserCount)).append("\n");
    sb.append("    bankType: ").append(toIndentedString(bankType)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
