// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微信支付平台补差API
//
// 微信支付平台补差API
//
// API version: 0.1.3

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.ecommercesubsidy.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import java.util.List;

/** SubsidiesReturnRequest */
public class SubsidiesReturnRequest {
  /** 电商平台二级商户号 说明：补差的电商平台二级商户，填写微信支付分配的商户号 */
  @SerializedName("sub_mchid")
  private String subMchid;

  /** 商户补差回退单号 说明：商户系统内部的补差回退单号，在商户系统内部唯一，同一补差回退单号多次请求等同一次。只能是数字、大小写字母_-|*@ */
  @SerializedName("out_order_no")
  private String outOrderNo;

  /** 微信订单号 说明：微信支付订单号 */
  @SerializedName("transaction_id")
  private String transactionId;

  /** 微信退款单号 说明：微信退款单号，微信系统退款返回的唯一标识。因用户账户异常而无法退款时可不传，其他情况必传 */
  @SerializedName("refund_id")
  private String refundId;

  /** 补差回退金额 说明：补差回退金额，单位为分，只能为整数，不能超过补差单的补差金额。如果指定了出资账户及金额，则必须为所有出资账户的金额之和 */
  @SerializedName("amount")
  private Long amount;

  /** 补差回退描述 说明：补差回退描述，查询的时候原样带回来 */
  @SerializedName("description")
  private String description;

  /** 微信补差单号 说明：微信补差单号，微信系统返回的唯一标识 */
  @SerializedName("subsidy_id")
  private String subsidyId;

  /**
   * 回退出资账户及金额 说明：回退需要从指定账户出资时，传递此参数指定出资金额（币种的最小单位，只能为整数）。
   * 当前仅支持从一个账户出资。使用场景需要满足以下条件：1、本次回退金额和已回退金额之和不超过该补差单的补差金额；2、本次回退的金额不超过指定的账户的实际可用资金
   */
  @SerializedName("from")
  private List<ReturnFrom> from;

  public String getSubMchid() {
    return subMchid;
  }

  public void setSubMchid(String subMchid) {
    this.subMchid = subMchid;
  }

  public String getOutOrderNo() {
    return outOrderNo;
  }

  public void setOutOrderNo(String outOrderNo) {
    this.outOrderNo = outOrderNo;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public String getRefundId() {
    return refundId;
  }

  public void setRefundId(String refundId) {
    this.refundId = refundId;
  }

  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getSubsidyId() {
    return subsidyId;
  }

  public void setSubsidyId(String subsidyId) {
    this.subsidyId = subsidyId;
  }

  public List<ReturnFrom> getFrom() {
    return from;
  }

  public void setFrom(List<ReturnFrom> from) {
    this.from = from;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubsidiesReturnRequest {\n");
    sb.append("    subMchid: ").append(toIndentedString(subMchid)).append("\n");
    sb.append("    outOrderNo: ").append(toIndentedString(outOrderNo)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    refundId: ").append(toIndentedString(refundId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    subsidyId: ").append(toIndentedString(subsidyId)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
