// Copyright 2021 Tencent Inc. All rights reserved.
//
// 电商退款API
//
// 境内电商退款功能相关API文档
//
// API version: 1.1.8

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.ecommercerefund.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** CreateRefundRequest */
public class CreateRefundRequest {
  /** 二级商户号 说明：微信支付分配二级商户的商户号 */
  @SerializedName("sub_mchid")
  private String subMchid;

  /** 电商平台APPID 说明：电商平台在微信公众平台申请服务号对应的APPID，申请商户功能的时候微信支付会配置绑定关系 */
  @SerializedName("sp_appid")
  private String spAppid;

  /** 二级商户APPID 说明：二级商户在微信申请公众号成功后分配的帐号ID，需要电商平台侧有配置绑定关系才能传 */
  @SerializedName("sub_appid")
  private String subAppid;

  /** 微信订单号 说明：原支付交易对应的微信订单号 */
  @SerializedName("transaction_id")
  private String transactionId;

  /** 商户订单号 说明：原支付交易对应的商户订单号 */
  @SerializedName("out_trade_no")
  private String outTradeNo;

  /** 商户退款单号 说明：商户系统内部的退款单号，商户系统内部唯一，只能是数字、大小写字母_-|*@ ，同一退款单号多次请求只退一笔。 */
  @SerializedName("out_refund_no")
  private String outRefundNo;

  /** 退款原因 说明：若商户传入，会在下发给用户的退款消息中体现退款原因 */
  @SerializedName("reason")
  private String reason;

  /** 订单金额 说明：订单金额信息 */
  @SerializedName("amount")
  private RefundReqAmount amount;

  /**
   * 退款结果回调url 说明：异步接收微信支付退款结果通知的回调地址，通知url必须为外网可访问的url，不能携带参数。
   * 如果参数中传了notify_url，则商户平台上配置的回调地址将不会生效，优先回调当前传的这个地址。
   */
  @SerializedName("notify_url")
  private String notifyUrl;

  /**
   * 退款出资商户 说明：REFUND_SOURCE_PARTNER_ADVANCE : 电商平台垫付，需要向微信支付申请开通 REFUND_SOURCE_SUB_MERCHANT :
   * 二级商户，默认值 注意：若传入REFUND_SOURCE_PARTNER_ADVANCE，仅代表可以使用垫付退款，实际出款账户需以退款申请受理结果或查单结果为准。
   */
  @SerializedName("refund_account")
  private String refundAccount;

  /**
   * 资金账户
   * 说明：若订单处于待分账状态，可以传入此参数，指定退款资金来源账户。当该字段不存在时，默认使用订单交易资金所在账户出款，即待分账时使用不可用余额的资金进行退款，已分账或无分账时使用可用余额的资金进行退款。
   * AVAILABLE：可用余额
   */
  @SerializedName("funds_account")
  private String fundsAccount;

  public String getSubMchid() {
    return subMchid;
  }

  public void setSubMchid(String subMchid) {
    this.subMchid = subMchid;
  }

  public String getSpAppid() {
    return spAppid;
  }

  public void setSpAppid(String spAppid) {
    this.spAppid = spAppid;
  }

  public String getSubAppid() {
    return subAppid;
  }

  public void setSubAppid(String subAppid) {
    this.subAppid = subAppid;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public String getOutTradeNo() {
    return outTradeNo;
  }

  public void setOutTradeNo(String outTradeNo) {
    this.outTradeNo = outTradeNo;
  }

  public String getOutRefundNo() {
    return outRefundNo;
  }

  public void setOutRefundNo(String outRefundNo) {
    this.outRefundNo = outRefundNo;
  }

  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public RefundReqAmount getAmount() {
    return amount;
  }

  public void setAmount(RefundReqAmount amount) {
    this.amount = amount;
  }

  public String getNotifyUrl() {
    return notifyUrl;
  }

  public void setNotifyUrl(String notifyUrl) {
    this.notifyUrl = notifyUrl;
  }

  public String getRefundAccount() {
    return refundAccount;
  }

  public void setRefundAccount(String refundAccount) {
    this.refundAccount = refundAccount;
  }

  public String getFundsAccount() {
    return fundsAccount;
  }

  public void setFundsAccount(String fundsAccount) {
    this.fundsAccount = fundsAccount;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateRefundRequest {\n");
    sb.append("    subMchid: ").append(toIndentedString(subMchid)).append("\n");
    sb.append("    spAppid: ").append(toIndentedString(spAppid)).append("\n");
    sb.append("    subAppid: ").append(toIndentedString(subAppid)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    outTradeNo: ").append(toIndentedString(outTradeNo)).append("\n");
    sb.append("    outRefundNo: ").append(toIndentedString(outRefundNo)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    notifyUrl: ").append(toIndentedString(notifyUrl)).append("\n");
    sb.append("    refundAccount: ").append(toIndentedString(refundAccount)).append("\n");
    sb.append("    fundsAccount: ").append(toIndentedString(fundsAccount)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
