// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微信支付营销系统开放API
//
// 新增立减金api
//
// API version: 3.4.0

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.cashcoupons.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import java.util.List;

/** CouponRule */
public class CouponRule {
  /** 券生效时间 说明：需要指定领取后延时生效可选填 */
  @SerializedName("coupon_available_time")
  private FavorAvailableTime couponAvailableTime;

  /** 固定面额满减券使用规则 说明：stock_type为NORMAL时必填 */
  @SerializedName("fixed_normal_coupon")
  private FixedValueStockMsg fixedNormalCoupon;

  /** 订单优惠标记 说明：订单优惠标记 */
  @SerializedName("goods_tag")
  private List<String> goodsTag;

  /** 指定支付模式 说明：支付方式 */
  @SerializedName("trade_type")
  private List<TradeType> tradeType;

  /** 是否可叠加其他优惠 说明：true-是；false-否 */
  @SerializedName("combine_use")
  private Boolean combineUse;

  /** 可核销商品编码 说明：可核销商品编码 */
  @SerializedName("available_items")
  private List<String> availableItems;

  /** 不参与优惠商品编码 说明：不参与优惠商品编码 */
  @SerializedName("unavailable_items")
  private List<String> unavailableItems;

  /** 可核销商户号 说明：可核销商户号 */
  @SerializedName("available_merchants")
  private List<String> availableMerchants;

  /** 指定卡信息 说明：当批次指定支付方式为某张银行卡时才生效，可选的 */
  @SerializedName("limit_card")
  private CardLimitation limitCard;

  /**
   * 指定支付方式 说明：限定该批次的指定支付方式，如零钱、指定银行卡等，需填入支付方式编码， 条目个数限制为[1，1] 。当前支持的支付方式，及其编码枚举值，请参考该文档：
   * https://docs.qq.com/sheet/DWGpMbWx3b1JCbldy?c=E3A0A0
   */
  @SerializedName("limit_pay")
  private List<String> limitPay;

  public FavorAvailableTime getCouponAvailableTime() {
    return couponAvailableTime;
  }

  public void setCouponAvailableTime(FavorAvailableTime couponAvailableTime) {
    this.couponAvailableTime = couponAvailableTime;
  }

  public FixedValueStockMsg getFixedNormalCoupon() {
    return fixedNormalCoupon;
  }

  public void setFixedNormalCoupon(FixedValueStockMsg fixedNormalCoupon) {
    this.fixedNormalCoupon = fixedNormalCoupon;
  }

  public List<String> getGoodsTag() {
    return goodsTag;
  }

  public void setGoodsTag(List<String> goodsTag) {
    this.goodsTag = goodsTag;
  }

  public List<TradeType> getTradeType() {
    return tradeType;
  }

  public void setTradeType(List<TradeType> tradeType) {
    this.tradeType = tradeType;
  }

  public Boolean getCombineUse() {
    return combineUse;
  }

  public void setCombineUse(Boolean combineUse) {
    this.combineUse = combineUse;
  }

  public List<String> getAvailableItems() {
    return availableItems;
  }

  public void setAvailableItems(List<String> availableItems) {
    this.availableItems = availableItems;
  }

  public List<String> getUnavailableItems() {
    return unavailableItems;
  }

  public void setUnavailableItems(List<String> unavailableItems) {
    this.unavailableItems = unavailableItems;
  }

  public List<String> getAvailableMerchants() {
    return availableMerchants;
  }

  public void setAvailableMerchants(List<String> availableMerchants) {
    this.availableMerchants = availableMerchants;
  }

  public CardLimitation getLimitCard() {
    return limitCard;
  }

  public void setLimitCard(CardLimitation limitCard) {
    this.limitCard = limitCard;
  }

  public List<String> getLimitPay() {
    return limitPay;
  }

  public void setLimitPay(List<String> limitPay) {
    this.limitPay = limitPay;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CouponRule {\n");
    sb.append("    couponAvailableTime: ")
        .append(toIndentedString(couponAvailableTime))
        .append("\n");
    sb.append("    fixedNormalCoupon: ").append(toIndentedString(fixedNormalCoupon)).append("\n");
    sb.append("    goodsTag: ").append(toIndentedString(goodsTag)).append("\n");
    sb.append("    tradeType: ").append(toIndentedString(tradeType)).append("\n");
    sb.append("    combineUse: ").append(toIndentedString(combineUse)).append("\n");
    sb.append("    availableItems: ").append(toIndentedString(availableItems)).append("\n");
    sb.append("    unavailableItems: ").append(toIndentedString(unavailableItems)).append("\n");
    sb.append("    availableMerchants: ").append(toIndentedString(availableMerchants)).append("\n");
    sb.append("    limitCard: ").append(toIndentedString(limitCard)).append("\n");
    sb.append("    limitPay: ").append(toIndentedString(limitPay)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
