/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.http;

import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.util.GsonUtil;
import java.net.URLConnection;
import java.util.Objects;

public final class FileRequestBody
implements RequestBody {
    private final String meta;
    private final String fileName;
    private final byte[] file;

    private FileRequestBody(String meta, String fileName, byte[] file) {
        this.meta = meta;
        this.fileName = fileName;
        this.file = file;
    }

    public String getMeta() {
        return this.meta;
    }

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getFile() {
        return this.file;
    }

    @Override
    public String getContentType() {
        String contentTypeFromName = URLConnection.guessContentTypeFromName(this.fileName);
        if (contentTypeFromName == null) {
            return MediaType.APPLICATION_OCTET_STREAM.getValue();
        }
        return contentTypeFromName;
    }

    public String toString() {
        return GsonUtil.getGson().toJson((Object)this);
    }

    public static class Builder {
        private String meta;
        private String fileName;
        private byte[] file;

        public Builder meta(String meta) {
            this.meta = meta;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder file(byte[] file) {
            this.file = file;
            return this;
        }

        public FileRequestBody build() {
            return new FileRequestBody(Objects.requireNonNull(this.meta), Objects.requireNonNull(this.fileName), Objects.requireNonNull(this.file));
        }
    }
}

