/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient.auth;

import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;

public class PublicKeyVerifier
implements Verifier {
    protected final PublicKey publicKey;
    protected final String publicKeyId;

    public PublicKeyVerifier(String publicKeyId, PublicKey publicKey) {
        this.publicKey = publicKey;
        this.publicKeyId = publicKeyId;
    }

    @Override
    public boolean verify(String serialNumber, byte[] message, String signature) {
        try {
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initVerify(this.publicKey);
            sign.update(message);
            return sign.verify(Base64.getDecoder().decode(signature));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301SHA256withRSA", e);
        }
        catch (SignatureException e) {
            throw new RuntimeException("\u7b7e\u540d\u9a8c\u8bc1\u8fc7\u7a0b\u53d1\u751f\u4e86\u9519\u8bef", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
    }

    @Override
    public PublicKey getValidPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getSerialNumber() {
        return this.publicKeyId;
    }
}

