/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonpercic.oklog3;

import com.github.simonpercic.oklog.core.BaseLogDataInterceptor;
import com.github.simonpercic.oklog3.HasResponseBodyManager;
import java.io.IOException;
import java.nio.charset.Charset;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LogDataInterceptor
extends BaseLogDataInterceptor<Interceptor.Chain, Request, Response, Headers, MediaType> {
    @NotNull
    private final HasResponseBodyManager hasResponseBodyManager = HasResponseBodyManager.create();

    LogDataInterceptor() {
    }

    protected Request request(Interceptor.Chain chain) {
        return chain.request();
    }

    protected String protocol(Interceptor.Chain chain) {
        Connection connection = chain.connection();
        Protocol protocol = connection != null ? connection.protocol() : Protocol.HTTP_1_1;
        return protocol.toString();
    }

    protected String requestMethod(Request request) {
        return request.method();
    }

    protected String requestUrl(Request request) {
        return request.url().toString();
    }

    protected String requestUrlPath(Request request) {
        return request.url().encodedPath();
    }

    protected String responseUrl(Response response) {
        return response.request().url().toString();
    }

    protected Headers requestHeaders(Request request) {
        return request.headers();
    }

    protected Headers responseHeaders(Response response) {
        return response.headers();
    }

    protected int headersCount(Headers headers) {
        return headers.size();
    }

    protected String headerName(Headers headers, int index) {
        return headers.name(index);
    }

    protected String headerValue(Headers headers, int index) {
        return headers.value(index);
    }

    protected String headerValue(Headers headers, String name) {
        return headers.get(name);
    }

    protected boolean hasRequestBody(Request request) {
        return request.body() != null;
    }

    protected boolean hasResponseBody(Response response) {
        return this.hasResponseBodyManager.hasBody(response);
    }

    protected int responseCode(Response response) {
        return response.code();
    }

    protected String responseMessage(Response response) {
        return response.message();
    }

    protected long requestContentLength(Request request) throws IOException {
        return request.body().contentLength();
    }

    protected long responseContentLength(Response response) throws IOException {
        return response.body().contentLength();
    }

    protected MediaType requestContentType(Request request) {
        return request.body().contentType();
    }

    protected MediaType responseContentType(Response response) {
        return response.body().contentType();
    }

    protected String contentTypeString(MediaType mediaType) {
        return mediaType.toString();
    }

    protected Charset contentTypeCharset(MediaType mediaType, Charset charset) {
        return mediaType.charset(charset);
    }

    @Nullable
    protected Charset responseContentTypeCharset(MediaType contentType, Charset charset) {
        return this.contentTypeCharset(contentType, charset);
    }

    protected void writeRequestBody(Request request, Buffer buffer) throws IOException {
        request.body().writeTo((BufferedSink)buffer);
    }

    protected BufferedSource responseBodySource(Response response) throws IOException {
        return response.body().source();
    }
}

