/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonpercic.oklog3;

import com.github.simonpercic.oklog.core.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import okhttp3.Response;
import okhttp3.internal.http.HttpHeaders;
import org.jetbrains.annotations.NotNull;

final class HasResponseBodyManager {
    private final boolean useNewMethod;
    private final Method legacyMethod;

    private HasResponseBodyManager(boolean useNewMethod, Method legacyMethod) {
        this.useNewMethod = useNewMethod;
        this.legacyMethod = legacyMethod;
    }

    @NotNull
    static HasResponseBodyManager create() {
        if (ReflectionUtils.hasClass((String)"okhttp3.internal.http.HttpHeaders")) {
            return new HasResponseBodyManager(true, null);
        }
        Method method = ReflectionUtils.getMethod((String)"okhttp3.internal.http.HttpEngine", (String)"hasBody", (Class[])new Class[]{Response.class});
        if (method == null) {
            throw new IllegalStateException("Response hasBody method is not available");
        }
        return new HasResponseBodyManager(false, method);
    }

    boolean hasBody(Response response) {
        if (this.useNewMethod) {
            return HttpHeaders.hasBody((Response)response);
        }
        try {
            return (Boolean)this.legacyMethod.invoke(null, response);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to invoke hasBody method: " + e.getMessage(), e);
        }
    }
}

