/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonpercic.oklog.core;

import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static boolean hasClass(@NotNull String className) {
        return ReflectionUtils.getClass(className) != null;
    }

    @Nullable
    public static Method getMethod(@NotNull String className, @NotNull String methodName, Class<?> ... paramTypes) {
        Class<?> clazz = ReflectionUtils.getClass(className);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    @Nullable
    private static Class<?> getClass(@NotNull String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

