/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonpercic.oklog.core;

import com.github.simonpercic.oklog.core.Logger;
import com.github.simonpercic.oklog.core.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;

class ReflectionTimberLogger
implements Logger {
    @Nullable
    private final Method debug;
    @Nullable
    private final Method warn;
    @Nullable
    private final Method error;
    private final Object[] emptyObjects = new Object[0];

    ReflectionTimberLogger() {
        this.debug = ReflectionUtils.getMethod("timber.log.Timber", "d", String.class, Object[].class);
        this.warn = ReflectionUtils.getMethod("timber.log.Timber", "w", String.class, Object[].class);
        this.error = ReflectionUtils.getMethod("timber.log.Timber", "e", Throwable.class, String.class, Object[].class);
    }

    @Override
    public void d(String tag, String message) {
        if (this.debug != null) {
            try {
                this.debug.invoke(null, message, this.emptyObjects);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    @Override
    public void w(String tag, String message) {
        if (this.warn != null) {
            try {
                this.warn.invoke(null, message, this.emptyObjects);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    @Override
    public void e(String tag, String message, Throwable throwable) {
        if (this.error != null) {
            try {
                this.error.invoke(null, throwable, message, this.emptyObjects);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    boolean isValid() {
        return this.debug != null && this.warn != null && this.error != null;
    }
}

