/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonpercic.oklog.core;

import com.github.simonpercic.oklog.core.AndroidLogger;
import com.github.simonpercic.oklog.core.CompressionUtil;
import com.github.simonpercic.oklog.core.JavaLogger;
import com.github.simonpercic.oklog.core.LogDataBuilder;
import com.github.simonpercic.oklog.core.LogDataConfig;
import com.github.simonpercic.oklog.core.LogDataConverter;
import com.github.simonpercic.oklog.core.LogInterceptor;
import com.github.simonpercic.oklog.core.Logger;
import com.github.simonpercic.oklog.core.ReflectionTimberLogger;
import com.github.simonpercic.oklog.core.ReflectionUtils;
import com.github.simonpercic.oklog.core.StringUtils;
import com.github.simonpercic.oklog.shared.LogDataSerializer;
import com.github.simonpercic.oklog.shared.data.LogData;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogManager {
    private static final String LOG_FORMAT = "LogManager: %s";
    private final String logUrlBase;
    private final LogInterceptor logInterceptor;
    private final Logger logger;
    private final boolean withRequestBody;
    private final boolean shortenInfoUrl;
    @NotNull
    private final LogDataConfig logDataConfig;
    @NotNull
    private final CompressionUtil compressionUtil;

    public LogManager(String urlBase, LogInterceptor logInterceptor, Logger logger, boolean ignoreTimber, boolean withRequestBody, boolean shortenInfoUrl, @NotNull LogDataConfig logDataConfig, @NotNull CompressionUtil compressionUtil) {
        this.logUrlBase = urlBase;
        this.logInterceptor = logInterceptor;
        this.logger = LogManager.resolveLogger(logger, ignoreTimber);
        this.withRequestBody = withRequestBody;
        this.shortenInfoUrl = shortenInfoUrl;
        this.logDataConfig = logDataConfig;
        this.compressionUtil = compressionUtil;
    }

    public void log(LogDataBuilder data) {
        LogData logData = LogDataConverter.convert(data, this.logDataConfig);
        String logUrl = this.getLogUrl(data.getResponseBody(), data.getRequestBody(), logData);
        if (this.logInterceptor == null || !this.logInterceptor.onLog(logUrl)) {
            this.logDebug(logUrl, data.getRequestMethod(), data.getRequestUrlPath());
        }
    }

    String getLogUrl(@Nullable String responseBody, @Nullable String requestBody, @Nullable LogData logData) {
        boolean infoUrl;
        String responseBodyString = this.compressBody(responseBody);
        if (StringUtils.isEmpty(responseBodyString)) {
            String message = "LogManager: responseBodyString string is empty";
            this.logger.w("OKLOG", message);
            responseBodyString = "0";
        }
        StringBuilder queryParams = new StringBuilder();
        if (this.withRequestBody) {
            queryParams = this.getRequestBodyQuery(queryParams, requestBody);
        }
        queryParams = this.getLogDataQuery(queryParams, logData);
        boolean bl = infoUrl = this.withRequestBody || this.shortenInfoUrl || this.logDataConfig.any();
        if (this.shortenInfoUrl) {
            queryParams = LogManager.appendQuerySymbol(queryParams, "s", "1");
        }
        String urlPath = infoUrl ? "r/" : "re/";
        String url = String.format("%s%s%s%s", this.logUrlBase, "/v1/", urlPath, responseBodyString);
        return url.concat(queryParams.toString());
    }

    @Nullable
    private String compressBody(@Nullable String body) {
        String bodyString;
        try {
            bodyString = this.compressionUtil.gzipBase64UrlSafe(body);
        }
        catch (IOException e) {
            this.logger.e("OKLOG", String.format(LOG_FORMAT, e.getMessage()), e);
            return null;
        }
        return bodyString;
    }

    @NotNull
    private StringBuilder getRequestBodyQuery(@NotNull StringBuilder queryParams, @Nullable String requestBody) {
        String requestBodyString = this.compressBody(requestBody);
        return LogManager.appendQuerySymbol(queryParams, "qb", requestBodyString);
    }

    @NotNull
    private StringBuilder getLogDataQuery(@NotNull StringBuilder queryParams, @Nullable LogData logData) {
        byte[] logDataBytes = LogDataSerializer.serialize((LogData)logData);
        String logDataString = null;
        try {
            logDataString = this.compressionUtil.gzipBase64UrlSafe(logDataBytes);
        }
        catch (IOException e) {
            this.logger.e("OKLOG", String.format(LOG_FORMAT, e.getMessage()), e);
        }
        return LogManager.appendQuerySymbol(queryParams, "d", logDataString);
    }

    void logDebug(String logUrl, String requestMethod, String requestUrlPath) {
        String format = "%s - %s %s - %s";
        this.logger.d("OKLOG", String.format(format, "OKLOG", requestMethod, requestUrlPath, logUrl));
    }

    @NotNull
    private static StringBuilder appendQuerySymbol(@NotNull StringBuilder queryParams, String querySymbol, String string) {
        if (!StringUtils.isEmpty(string)) {
            boolean first = queryParams.length() == 0;
            queryParams.append(first ? "?" : "&");
            queryParams.append(querySymbol);
            queryParams.append('=');
            queryParams.append(string);
        }
        return queryParams;
    }

    @NotNull
    private static Logger resolveLogger(@Nullable Logger logger, boolean ignoreTimber) {
        if (logger != null) {
            return logger;
        }
        if (!ignoreTimber) {
            ReflectionTimberLogger reflectionTimberLogger;
            Logger timberLogger = LogManager.resolveTimberLogger();
            if (timberLogger != null) {
                return timberLogger;
            }
            if (ReflectionUtils.hasClass("timber.log.Timber") && (reflectionTimberLogger = new ReflectionTimberLogger()).isValid()) {
                return reflectionTimberLogger;
            }
        }
        if (ReflectionUtils.hasClass("android.util.Log")) {
            return new AndroidLogger();
        }
        return new JavaLogger();
    }

    @Nullable
    private static Logger resolveTimberLogger() {
        Method provideLoggerMethod = ReflectionUtils.getMethod("com.github.simonpercic.oklog.core.android.TimberLoggerProvider", "provideLogger", new Class[0]);
        if (provideLoggerMethod != null) {
            try {
                return (Logger)provideLoggerMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }
}

