/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonpercic.oklog.core;

import com.github.simonpercic.collectionhelper.CollectionHelper;
import com.github.simonpercic.oklog.core.LogDataBuilder;
import com.github.simonpercic.oklog.core.LogDataConfig;
import com.github.simonpercic.oklog.shared.data.BodyState;
import com.github.simonpercic.oklog.shared.data.HeaderData;
import com.github.simonpercic.oklog.shared.data.LogData;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LogDataConverter {
    private LogDataConverter() {
    }

    @Nullable
    static LogData convert(@Nullable LogDataBuilder builder, @NotNull LogDataConfig config) {
        if (builder == null) {
            return null;
        }
        if (!config.any()) {
            return null;
        }
        List<HeaderData> requestHeaders = config.requestHeaders ? LogDataConverter.convertHeaders(builder.getRequestHeaders()) : null;
        List<HeaderData> responseHeaders = config.responseHeaders ? LogDataConverter.convertHeaders(builder.getResponseHeaders()) : null;
        LogData.Builder logDataBuilder = new LogData.Builder();
        if (config.requestMethod) {
            logDataBuilder.request_method(builder.getRequestMethod());
        }
        if (config.requestUrl) {
            logDataBuilder.request_url(builder.getRequestUrl());
        }
        if (config.protocol) {
            logDataBuilder.protocol(builder.getProtocol());
        }
        if (config.requestContentType) {
            logDataBuilder.request_content_type(builder.getRequestContentType());
        }
        if (config.requestContentLength) {
            logDataBuilder.request_content_length(Long.valueOf(builder.getRequestContentLength()));
        }
        if (config.requestBodyState) {
            logDataBuilder.request_body_state(BodyState.fromValue((int)builder.getRequestBodyState().getIntValue()));
        }
        if (config.requestFailedState) {
            logDataBuilder.request_failed(Boolean.valueOf(builder.isRequestFailed()));
        }
        if (config.responseCode) {
            logDataBuilder.response_code(Integer.valueOf(builder.getResponseCode()));
        }
        if (config.responseMessage) {
            logDataBuilder.response_message(builder.getResponseMessage());
        }
        if (config.responseUrl) {
            logDataBuilder.response_url(builder.getResponseUrl());
        }
        if (config.responseDuration) {
            logDataBuilder.response_duration_ms(Long.valueOf(builder.getResponseDurationMs()));
        }
        if (config.responseBodyState) {
            logDataBuilder.response_body_state(BodyState.fromValue((int)builder.getResponseBodyState().getIntValue()));
        }
        if (config.responseSize) {
            logDataBuilder.response_content_length(Long.valueOf(builder.getResponseContentLength()));
            logDataBuilder.response_body_size(Long.valueOf(builder.getResponseBodySize()));
        }
        if (requestHeaders != null) {
            logDataBuilder.request_headers(requestHeaders);
        }
        if (responseHeaders != null) {
            logDataBuilder.response_headers(responseHeaders);
        }
        return logDataBuilder.build();
    }

    @Nullable
    private static List<HeaderData> convertHeaders(@Nullable List<LogDataBuilder.HeaderDataBuilder> headers) {
        if (CollectionHelper.isEmpty(headers)) {
            return null;
        }
        ArrayList<HeaderData> result = new ArrayList<HeaderData>();
        for (LogDataBuilder.HeaderDataBuilder header : headers) {
            HeaderData headerData = new HeaderData.Builder().name(header.getName()).value(header.getValue()).build();
            result.add(headerData);
        }
        return result;
    }
}

