/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonpercic.oklog.core;

import java.util.ArrayList;
import java.util.List;

public class LogDataBuilder {
    private String requestMethod;
    private String requestUrl;
    private String requestUrlPath;
    private String protocol;
    private String requestContentType;
    private long requestContentLength;
    private List<HeaderDataBuilder> requestHeaders;
    private String requestBody;
    private BodyState requestBodyState = BodyState.PLAIN_BODY;
    private boolean requestFailed;
    private int responseCode;
    private String responseMessage;
    private String responseUrl;
    private long responseDurationMs;
    private long responseContentLength;
    private List<HeaderDataBuilder> responseHeaders;
    private BodyState responseBodyState = BodyState.PLAIN_BODY;
    private long responseBodySize;
    private String responseBody;

    LogDataBuilder() {
    }

    LogDataBuilder requestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    LogDataBuilder requestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
        return this;
    }

    LogDataBuilder requestUrlPath(String requestUrlPath) {
        this.requestUrlPath = requestUrlPath;
        return this;
    }

    LogDataBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    LogDataBuilder requestContentType(String contentType) {
        this.requestContentType = contentType;
        return this;
    }

    LogDataBuilder requestContentLength(long contentLength) {
        this.requestContentLength = contentLength;
        return this;
    }

    LogDataBuilder addRequestHeader(String name, String value) {
        if (this.requestHeaders == null) {
            this.requestHeaders = new ArrayList<HeaderDataBuilder>();
        }
        this.requestHeaders.add(new HeaderDataBuilder(name, value));
        return this;
    }

    LogDataBuilder requestBody(String requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    LogDataBuilder requestBodyState(BodyState requestBodyState) {
        this.requestBodyState = requestBodyState;
        return this;
    }

    public LogDataBuilder requestFailed() {
        this.requestFailed = true;
        return this;
    }

    LogDataBuilder responseCode(int responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    LogDataBuilder responseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
        return this;
    }

    LogDataBuilder responseUrl(String responseUrl) {
        this.responseUrl = responseUrl;
        return this;
    }

    public LogDataBuilder responseDurationMs(long responseDurationMs) {
        this.responseDurationMs = responseDurationMs;
        return this;
    }

    LogDataBuilder responseContentLength(long responseContentLength) {
        this.responseContentLength = responseContentLength;
        return this;
    }

    LogDataBuilder addResponseHeader(String name, String value) {
        if (this.responseHeaders == null) {
            this.responseHeaders = new ArrayList<HeaderDataBuilder>();
        }
        this.responseHeaders.add(new HeaderDataBuilder(name, value));
        return this;
    }

    LogDataBuilder responseBodyState(BodyState responseBodyState) {
        this.responseBodyState = responseBodyState;
        return this;
    }

    LogDataBuilder responseBodySize(long responseBodySize) {
        this.responseBodySize = responseBodySize;
        return this;
    }

    LogDataBuilder responseBody(String responseBody) {
        this.responseBody = responseBody;
        return this;
    }

    String getRequestMethod() {
        return this.requestMethod;
    }

    String getRequestUrl() {
        return this.requestUrl;
    }

    String getRequestUrlPath() {
        return this.requestUrlPath;
    }

    String getProtocol() {
        return this.protocol;
    }

    String getRequestContentType() {
        return this.requestContentType;
    }

    long getRequestContentLength() {
        return this.requestContentLength;
    }

    List<HeaderDataBuilder> getRequestHeaders() {
        return this.requestHeaders;
    }

    String getRequestBody() {
        return this.requestBody;
    }

    BodyState getRequestBodyState() {
        return this.requestBodyState;
    }

    boolean isRequestFailed() {
        return this.requestFailed;
    }

    int getResponseCode() {
        return this.responseCode;
    }

    String getResponseMessage() {
        return this.responseMessage;
    }

    String getResponseUrl() {
        return this.responseUrl;
    }

    long getResponseDurationMs() {
        return this.responseDurationMs;
    }

    long getResponseContentLength() {
        return this.responseContentLength;
    }

    List<HeaderDataBuilder> getResponseHeaders() {
        return this.responseHeaders;
    }

    BodyState getResponseBodyState() {
        return this.responseBodyState;
    }

    long getResponseBodySize() {
        return this.responseBodySize;
    }

    String getResponseBody() {
        return this.responseBody;
    }

    public String toString() {
        String requestHeadersString = "";
        if (this.requestHeaders != null) {
            for (HeaderDataBuilder requestHeader : this.requestHeaders) {
                requestHeadersString = requestHeadersString + requestHeader.toString() + " ";
            }
        }
        String responseHeadersString = "";
        if (this.responseHeaders != null) {
            for (HeaderDataBuilder responseHeader : this.responseHeaders) {
                responseHeadersString = responseHeadersString + responseHeader.toString() + " ";
            }
        }
        return "LogDataBuilder{\nrequestMethod='" + this.requestMethod + '\'' + "\n, requestUrl='" + this.requestUrl + '\'' + "\n, requestUrlPath='" + this.requestUrlPath + '\'' + "\n, protocol='" + this.protocol + '\'' + "\n, requestContentType='" + this.requestContentType + '\'' + "\n, requestContentLength=" + this.requestContentLength + "\n, requestHeaders=" + requestHeadersString + "\n, requestBody='" + this.requestBody + '\'' + "\n, requestBodyState=" + (Object)((Object)this.requestBodyState) + "\n, requestFailed=" + this.requestFailed + "\n, responseCode=" + this.responseCode + "\n, responseMessage='" + this.responseMessage + '\'' + "\n, responseUrl='" + this.responseUrl + '\'' + "\n, responseDurationMs=" + this.responseDurationMs + "\n, responseContentLength=" + this.responseContentLength + "\n, responseHeaders=" + responseHeadersString + "\n, responseBodyState=" + (Object)((Object)this.responseBodyState) + "\n, responseBodySize=" + this.responseBodySize + "\n, responseBody='" + this.responseBody + '\'' + "\n" + '}';
    }

    static final class HeaderDataBuilder {
        private final String name;
        private final String value;

        private HeaderDataBuilder(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }

        public String toString() {
            return "HeaderDataBuilder{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    public static enum BodyState {
        PLAIN_BODY(1),
        NO_BODY(2),
        ENCODED_BODY(3),
        BINARY_BODY(4),
        CHARSET_MALFORMED(5);

        private final int intValue;

        private BodyState(int intValue) {
            this.intValue = intValue;
        }

        int getIntValue() {
            return this.intValue;
        }
    }
}

