/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonpercic.oklog.core;

import com.github.simonpercic.oklog.core.Constants;
import com.github.simonpercic.oklog.core.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import okio.BufferedSink;
import okio.ByteString;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

public class CompressionUtil {
    private static String gzipBase64(String string) throws IOException {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        return CompressionUtil.gzipBase64(string.getBytes(Constants.CHARSET_UTF8));
    }

    private static String gzipBase64(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(bytes.length);
        BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink(Okio.sink((OutputStream)out)));
        gzipSink.write(bytes);
        gzipSink.close();
        byte[] result = out.toByteArray();
        out.close();
        ByteString byteString = ByteString.of((byte[])result);
        return byteString.base64Url();
    }

    String gzipBase64UrlSafe(String string) throws IOException {
        String result = CompressionUtil.gzipBase64(string);
        if (!StringUtils.isEmpty(result)) {
            result = result.replaceAll("\n", "");
        }
        return result;
    }

    String gzipBase64UrlSafe(byte[] bytes) throws IOException {
        String result = CompressionUtil.gzipBase64(bytes);
        if (!StringUtils.isEmpty(result)) {
            result = result.replaceAll("\n", "");
        }
        return result;
    }
}

