/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonpercic.oklog.core;

import com.github.simonpercic.oklog.core.LogDataConfig;
import com.github.simonpercic.oklog.core.LogInterceptor;
import com.github.simonpercic.oklog.core.Logger;
import com.github.simonpercic.oklog.core.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BaseOkLogInterceptorBuilder {
    protected String logUrlBase = "http://oklog.responseecho.com";
    protected LogInterceptor logInterceptor;
    protected Logger logger;
    protected boolean ignoreTimber;
    protected boolean requestBody = true;
    protected boolean shortenInfoUrl;
    private boolean requestMethod = true;
    private boolean requestUrl = true;
    private boolean protocol;
    private boolean requestContentType;
    private boolean requestContentLength = true;
    private boolean requestBodyState = true;
    private boolean requestHeaders;
    private boolean requestFailedState = true;
    private boolean responseCode = true;
    private boolean responseMessage = true;
    private boolean responseUrl;
    private boolean responseDuration = true;
    private boolean responseSize = true;
    private boolean responseBodyState = true;
    private boolean responseHeaders;

    protected BaseOkLogInterceptorBuilder() {
    }

    protected void baseSetBaseUrl(String url) {
        if (!StringUtils.isEmpty(url)) {
            this.logUrlBase = url;
        }
    }

    protected void baseIgnoreTimber(boolean ignoreTimber) {
        this.ignoreTimber = ignoreTimber;
    }

    protected void baseSetLogInterceptor(LogInterceptor logInterceptor) {
        this.logInterceptor = logInterceptor;
    }

    protected void baseLogger(Logger logger) {
        this.logger = logger;
    }

    protected void baseWithRequestBody(boolean requestBody) {
        this.requestBody = requestBody;
    }

    protected void baseShortenInfoUrl(boolean shortenInfoUrl) {
        this.shortenInfoUrl = shortenInfoUrl;
    }

    protected void baseWithRequestMethod(boolean requestMethod) {
        this.requestMethod = requestMethod;
    }

    protected void baseWithRequestUrl(boolean requestUrl) {
        this.requestUrl = requestUrl;
    }

    protected void baseWithProtocol(boolean protocol) {
        this.protocol = protocol;
    }

    protected void baseWithRequestContentType(boolean requestContentType) {
        this.requestContentType = requestContentType;
    }

    protected void baseWithRequestContentLength(boolean requestContentLength) {
        this.requestContentLength = requestContentLength;
    }

    protected void baseWithRequestBodyState(boolean requestBodyState) {
        this.requestBodyState = requestBodyState;
    }

    protected void baseWithRequestHeaders(boolean requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    protected void baseWithRequestFailedState(boolean requestFailedState) {
        this.requestFailedState = requestFailedState;
    }

    protected void baseWithResponseCode(boolean responseCode) {
        this.responseCode = responseCode;
    }

    protected void baseWithResponseMessage(boolean responseMessage) {
        this.responseMessage = responseMessage;
    }

    protected void baseWithResponseUrl(boolean responseUrl) {
        this.responseUrl = responseUrl;
    }

    protected void baseWithResponseDuration(boolean responseDuration) {
        this.responseDuration = responseDuration;
    }

    protected void baseWithResponseSize(boolean responseSize) {
        this.responseSize = responseSize;
    }

    protected void baseWithResponseBodyState(boolean responseBodyState) {
        this.responseBodyState = responseBodyState;
    }

    protected void baseWithResponseHeaders(boolean responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    protected void baseWithNoLogData() {
        this.setLogData(false);
    }

    protected void baseWithAllLogData() {
        this.setLogData(true);
    }

    private void setLogData(boolean value) {
        this.requestBody = value;
        this.requestMethod = value;
        this.requestUrl = value;
        this.protocol = value;
        this.requestContentType = value;
        this.requestContentLength = value;
        this.requestBodyState = value;
        this.requestHeaders = value;
        this.requestFailedState = value;
        this.responseCode = value;
        this.responseMessage = value;
        this.responseUrl = value;
        this.responseDuration = value;
        this.responseSize = value;
        this.responseBodyState = value;
        this.responseHeaders = value;
    }

    @NotNull
    protected LogDataConfig buildLogDataConfig() {
        return new LogDataConfig(this.requestMethod, this.requestUrl, this.protocol, this.requestContentType, this.requestContentLength, this.requestBodyState, this.requestHeaders, this.requestFailedState, this.responseCode, this.responseMessage, this.responseUrl, this.responseDuration, this.responseSize, this.responseBodyState, this.responseHeaders);
    }
}

