/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonpercic.oklog.core;

import com.github.simonpercic.oklog.core.Constants;
import com.github.simonpercic.oklog.core.LogDataBuilder;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLogDataInterceptor<Chain, Request, Response, Headers, MediaType> {
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String IDENTITY = "identity";

    protected abstract Request request(Chain var1);

    protected abstract String protocol(Chain var1);

    protected abstract String requestMethod(Request var1);

    protected abstract String requestUrl(Request var1);

    protected abstract String requestUrlPath(Request var1);

    protected abstract String responseUrl(Response var1);

    protected abstract Headers requestHeaders(Request var1);

    protected abstract Headers responseHeaders(Response var1);

    protected abstract int headersCount(Headers var1);

    protected abstract String headerName(Headers var1, int var2);

    protected abstract String headerValue(Headers var1, int var2);

    protected abstract String headerValue(Headers var1, String var2);

    protected abstract boolean hasRequestBody(Request var1);

    protected abstract boolean hasResponseBody(Response var1);

    protected abstract int responseCode(Response var1);

    protected abstract String responseMessage(Response var1);

    protected abstract long requestContentLength(Request var1) throws IOException;

    protected abstract long responseContentLength(Response var1) throws IOException;

    protected abstract MediaType requestContentType(Request var1);

    protected abstract MediaType responseContentType(Response var1);

    protected abstract String contentTypeString(MediaType var1);

    protected abstract Charset contentTypeCharset(MediaType var1, Charset var2);

    @Nullable
    protected abstract Charset responseContentTypeCharset(MediaType var1, Charset var2);

    protected abstract void writeRequestBody(Request var1, Buffer var2) throws IOException;

    protected abstract BufferedSource responseBodySource(Response var1) throws IOException;

    @NotNull
    public RequestLogData<Request> processRequest(Chain chain) throws IOException {
        LogDataBuilder logDataBuilder = new LogDataBuilder();
        Request request = this.request(chain);
        boolean hasRequestBody = this.hasRequestBody(request);
        logDataBuilder.requestMethod(this.requestMethod(request)).requestUrl(this.requestUrl(request)).requestUrlPath(this.requestUrlPath(request)).protocol(this.protocol(chain));
        if (hasRequestBody) {
            MediaType mediaType = this.requestContentType(request);
            if (mediaType != null) {
                logDataBuilder.requestContentType(this.contentTypeString(mediaType));
            }
            long contentLength = this.requestContentLength(request);
            logDataBuilder.requestContentLength(contentLength);
        }
        Headers headers = this.requestHeaders(request);
        int count = this.headersCount(headers);
        for (int i = 0; i < count; ++i) {
            String name = this.headerName(headers, i);
            if (CONTENT_TYPE.equalsIgnoreCase(name) || CONTENT_LENGTH.equalsIgnoreCase(name)) continue;
            logDataBuilder.addRequestHeader(name, this.headerValue(headers, i));
        }
        if (!hasRequestBody) {
            logDataBuilder.requestBodyState(LogDataBuilder.BodyState.NO_BODY);
        } else if (this.bodyEncoded(headers)) {
            logDataBuilder.requestBodyState(LogDataBuilder.BodyState.ENCODED_BODY);
        } else {
            Buffer buffer = new Buffer();
            this.writeRequestBody(request, buffer);
            Charset charset = Constants.CHARSET_UTF8;
            MediaType contentType = this.requestContentType(request);
            if (contentType != null) {
                charset = this.contentTypeCharset(contentType, Constants.CHARSET_UTF8);
            }
            if (BaseLogDataInterceptor.isPlaintext(buffer)) {
                logDataBuilder.requestBody(buffer.readString(charset));
            } else {
                logDataBuilder.requestBodyState(LogDataBuilder.BodyState.BINARY_BODY);
            }
        }
        return new RequestLogData(request, logDataBuilder);
    }

    @NotNull
    public ResponseLogData<Response> processResponse(LogDataBuilder logDataBuilder, Response response) throws IOException {
        long contentLength = this.responseContentLength(response);
        logDataBuilder.responseCode(this.responseCode(response)).responseMessage(this.responseMessage(response)).responseContentLength(contentLength).responseUrl(this.responseUrl(response));
        Headers responseHeaders = this.responseHeaders(response);
        int count = this.headersCount(responseHeaders);
        for (int i = 0; i < count; ++i) {
            String name = this.headerName(responseHeaders, i);
            if (CONTENT_LENGTH.equalsIgnoreCase(name) || this.skipResponseHeader(name)) continue;
            logDataBuilder.addResponseHeader(name, this.headerValue(responseHeaders, i));
        }
        if (!this.hasResponseBody(response)) {
            logDataBuilder.responseBodyState(LogDataBuilder.BodyState.NO_BODY);
        } else if (this.bodyEncoded(responseHeaders)) {
            logDataBuilder.responseBodyState(LogDataBuilder.BodyState.ENCODED_BODY);
        } else {
            BufferedSource source = this.responseBodySource(response);
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            Charset charset = Constants.CHARSET_UTF8;
            MediaType contentType = this.responseContentType(response);
            if (contentType != null && (charset = this.responseContentTypeCharset(contentType, Constants.CHARSET_UTF8)) == null) {
                logDataBuilder.responseBodyState(LogDataBuilder.BodyState.CHARSET_MALFORMED);
                return new ResponseLogData(response, logDataBuilder);
            }
            if (!BaseLogDataInterceptor.isPlaintext(buffer)) {
                logDataBuilder.responseBodyState(LogDataBuilder.BodyState.BINARY_BODY);
                logDataBuilder.responseBodySize(buffer.size());
                return new ResponseLogData(response, logDataBuilder);
            }
            if (contentLength != 0L) {
                logDataBuilder.responseBody(buffer.clone().readString(charset));
            }
            logDataBuilder.responseBodySize(buffer.size());
        }
        return new ResponseLogData(response, logDataBuilder);
    }

    protected boolean skipResponseHeader(String headerName) {
        return false;
    }

    static boolean isPlaintext(Buffer buffer) throws EOFException {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    private boolean bodyEncoded(Headers headers) {
        String contentEncoding = this.headerValue(headers, CONTENT_ENCODING);
        return contentEncoding != null && !contentEncoding.equalsIgnoreCase(IDENTITY);
    }

    public static final class ResponseLogData<Response> {
        private final Response response;
        private final LogDataBuilder logData;

        private ResponseLogData(Response response, LogDataBuilder logData) {
            this.response = response;
            this.logData = logData;
        }

        public Response getResponse() {
            return this.response;
        }

        public LogDataBuilder getLogData() {
            return this.logData;
        }
    }

    public static final class RequestLogData<Request> {
        private final Request request;
        private final LogDataBuilder logData;

        private RequestLogData(Request request, LogDataBuilder logData) {
            this.request = request;
            this.logData = logData;
        }

        public Request getRequest() {
            return this.request;
        }

        public LogDataBuilder getLogData() {
            return this.logData;
        }
    }
}

