/*
 * Decompiled with CFR 0.152.
 */
package com.github.simonpercic.collectionhelper;

import com.github.simonpercic.collectionhelper.Mapper;
import com.github.simonpercic.collectionhelper.Predicate;
import com.github.simonpercic.collectionhelper.exceptions.InvalidOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CollectionHelper {
    public static final int NOT_FOUND_INDEX = -1;

    private CollectionHelper() {
    }

    public static <T> List<T> filter(Collection<T> items, Predicate<T> predicate) {
        ArrayList<T> result = new ArrayList<T>();
        if (!CollectionHelper.isEmpty(items)) {
            for (T item : items) {
                if (!predicate.apply(item)) continue;
                result.add(item);
            }
        }
        return result;
    }

    public static <T> T first(Collection<T> items, Predicate<T> predicate) {
        T firstOrNull = CollectionHelper.firstOrNull(items, predicate);
        if (firstOrNull == null) {
            throw new InvalidOperationException("No items match!");
        }
        return firstOrNull;
    }

    public static <T> T firstOrNull(Collection<T> items, Predicate<T> predicate) {
        if (!CollectionHelper.isEmpty(items)) {
            for (T item : items) {
                if (!predicate.apply(item)) continue;
                return item;
            }
        }
        return null;
    }

    public static <T> int firstIndexOf(Collection<T> items, Predicate<T> predicate) {
        if (!CollectionHelper.isEmpty(items)) {
            int index = 0;
            for (T item : items) {
                if (predicate.apply(item)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public static <T> boolean any(Collection<T> items, Predicate<T> predicate) {
        T firstOrNull = CollectionHelper.firstOrNull(items, predicate);
        return firstOrNull != null;
    }

    public static <T> boolean all(Collection<T> items, Predicate<T> predicate) {
        if (CollectionHelper.isEmpty(items)) {
            return false;
        }
        for (T item : items) {
            if (predicate.apply(item)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Collection items) {
        return items == null || items.size() == 0;
    }

    public static <T> T single(Collection<T> items, Predicate<T> predicate) {
        T singleOrNull = CollectionHelper.singleOrNull(items, predicate);
        if (singleOrNull == null) {
            throw new InvalidOperationException("No items match!");
        }
        return singleOrNull;
    }

    public static <T> T singleOrNull(Collection<T> items, Predicate<T> predicate) {
        if (CollectionHelper.isEmpty(items)) {
            return null;
        }
        T result = null;
        for (T item : items) {
            if (!predicate.apply(item)) continue;
            if (result == null) {
                result = item;
                continue;
            }
            throw new InvalidOperationException("Multiple items match!");
        }
        return result;
    }

    public static <T> int singleIndexOf(Collection<T> items, Predicate<T> predicate) {
        int result = -1;
        if (!CollectionHelper.isEmpty(items)) {
            int index = 0;
            for (T item : items) {
                if (predicate.apply(item)) {
                    if (result == -1) {
                        result = index;
                    } else {
                        throw new InvalidOperationException("Multiple items match!");
                    }
                }
                ++index;
            }
        }
        return result;
    }

    public static <T> int count(Collection<T> items, Predicate<T> predicate) {
        int count = 0;
        if (!CollectionHelper.isEmpty(items)) {
            for (T element : items) {
                if (!predicate.apply(element)) continue;
                ++count;
            }
        }
        return count;
    }

    public static <TSource, TResult> List<TResult> map(Collection<TSource> items, Mapper<TSource, TResult> mapper) {
        if (CollectionHelper.isEmpty(items)) {
            return new ArrayList();
        }
        ArrayList<TResult> result = new ArrayList<TResult>(items.size());
        for (TSource item : items) {
            TResult mappedItem = mapper.map(item);
            result.add(mappedItem);
        }
        return result;
    }
}

