/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.github.javafaker.Faker;
import com.power.common.util.DateTimeUtil;
import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class DocUtil {
    private static Faker faker = new Faker(new Locale("zh-CN"));
    private static Faker enFaker = new Faker(new Locale("en-US"));
    private static Map<String, String> fieldValue = new LinkedHashMap<String, String>();

    public static String jsonValueByType(String type0) {
        String type = type0.contains(".") ? type0.substring(type0.lastIndexOf(".") + 1, type0.length()) : type0;
        String value = RandomUtil.randomValueByType((String)type);
        if ("Integer".equals(type) || "int".equals(type) || "Long".equals(type) || "long".equals(type) || "Double".equals(type) || "double".equals(type) || "Float".equals(type) || "float".equals(type) || "BigDecimal".equals(type) || "boolean".equals(type) || "Boolean".equals(type) || "Short".equals(type)) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\"").append(value).append("\"");
        return builder.toString();
    }

    public static String getValByTypeAndFieldName(String type0, String filedName) {
        String type = type0.contains("java.lang") ? type0.substring(type0.lastIndexOf(".") + 1, type0.length()) : type0;
        String key = filedName.toLowerCase() + "-" + type.toLowerCase();
        String value = null;
        for (Map.Entry<String, String> entry : fieldValue.entrySet()) {
            if (!key.contains(entry.getKey())) continue;
            value = entry.getValue();
            break;
        }
        if (null == value) {
            return DocUtil.jsonValueByType(type0);
        }
        if ("string".equals(type.toLowerCase())) {
            StringBuilder builder = new StringBuilder();
            builder.append("\"").append(value).append("\"");
            return builder.toString();
        }
        return value;
    }

    public static boolean isClassName(String className) {
        if (StringUtil.isEmpty((String)className)) {
            return false;
        }
        if (className.contains("<") && !className.contains(">")) {
            return false;
        }
        return !className.contains(">") || className.contains("<");
    }

    static {
        fieldValue.put("uuid-string", UUID.randomUUID().toString());
        fieldValue.put("uid", UUID.randomUUID().toString());
        fieldValue.put("nickname-string", enFaker.name().username());
        fieldValue.put("name-string", faker.name().username());
        fieldValue.put("url-string", faker.internet().url());
        fieldValue.put("username-string", faker.name().username());
        fieldValue.put("age-int", String.valueOf(RandomUtil.randomInt((int)0, (int)70)));
        fieldValue.put("age-integer", String.valueOf(RandomUtil.randomInt((int)0, (int)70)));
        fieldValue.put("email-string", faker.internet().emailAddress());
        fieldValue.put("domain-string", faker.internet().domainName());
        fieldValue.put("phone-string", faker.phoneNumber().cellPhone());
        fieldValue.put("mobile-string", faker.phoneNumber().cellPhone());
        fieldValue.put("telephone-string", faker.phoneNumber().phoneNumber());
        fieldValue.put("address-string", faker.address().fullAddress().replace(",", "\uff0c"));
        fieldValue.put("ip-string", faker.internet().ipV4Address());
        fieldValue.put("ipv4-string", faker.internet().ipV4Address());
        fieldValue.put("ipv6-string", faker.internet().ipV6Address());
        fieldValue.put("company-string", faker.company().name());
        fieldValue.put("timestamp-long", String.valueOf(System.currentTimeMillis()));
        fieldValue.put("timestamp-string", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        fieldValue.put("time-long", String.valueOf(System.currentTimeMillis()));
        fieldValue.put("time-string", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        fieldValue.put("birthday-string", DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd"));
        fieldValue.put("birthday-long", String.valueOf(System.currentTimeMillis()));
        fieldValue.put("code-string", String.valueOf(RandomUtil.randomInt((int)100, (int)99999)));
        fieldValue.put("message-string", "success,fail".split(",")[RandomUtil.randomInt((int)0, (int)1)]);
    }
}

