/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.FileUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.SourceBuilder;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiErrorCode;
import com.power.doc.utils.BeetlTemplateUtil;
import java.util.List;
import org.beetl.core.Template;

public class ApiDocBuilder {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public static void builderControllersApi(String outPath, boolean isStrict) {
        SourceBuilder sourceBuilder = new SourceBuilder(isStrict);
        List<ApiDoc> apiDocList = sourceBuilder.getControllerApiData();
        ApiDocBuilder.buildApiDoc(apiDocList, outPath);
    }

    public static void builderControllersApi(ApiConfig config) {
        if (null == config) {
            throw new NullPointerException("ApiConfig can't be null");
        }
        if (StringUtil.isEmpty((String)config.getOutPath())) {
            throw new RuntimeException("doc output path can't be null or empty");
        }
        SourceBuilder sourceBuilder = new SourceBuilder(config);
        List<ApiDoc> apiDocList = sourceBuilder.getControllerApiData();
        if (config.isAllInOne()) {
            ApiDocBuilder.buildAllInOne(apiDocList, config.getErrorCodes(), config.getOutPath());
        } else {
            ApiDocBuilder.buildApiDoc(apiDocList, config.getOutPath());
            ApiDocBuilder.buildErrorCodeDoc(config.getErrorCodes(), config.getOutPath());
        }
    }

    public static void buildSingleControllerApi(String outPath, String controllerName) {
        FileUtil.mkdirs((String)outPath);
        SourceBuilder sourceBuilder = new SourceBuilder(true);
        ApiDoc doc = sourceBuilder.getSingleControllerApiData(controllerName);
        Template mapper = BeetlTemplateUtil.getByName("ApiDoc.btl");
        mapper.binding("desc", (Object)doc.getDesc());
        mapper.binding("name", (Object)doc.getName());
        mapper.binding("list", doc.getList());
        FileUtil.writeFileNotAppend((String)mapper.render(), (String)(outPath + FILE_SEPARATOR + doc.getName() + "Api.md"));
    }

    private static void buildApiDoc(List<ApiDoc> apiDocList, String outPath) {
        FileUtil.mkdirs((String)outPath);
        for (ApiDoc doc : apiDocList) {
            Template mapper = BeetlTemplateUtil.getByName("ApiDoc.btl");
            mapper.binding("desc", (Object)doc.getDesc());
            mapper.binding("name", (Object)doc.getName());
            mapper.binding("list", doc.getList());
            FileUtil.nioWriteFile((String)mapper.render(), (String)(outPath + FILE_SEPARATOR + doc.getName() + "Api.md"));
        }
    }

    private static void buildAllInOne(List<ApiDoc> apiDocList, List<ApiErrorCode> errorCodeList, String outPath) {
        FileUtil.mkdirs((String)outPath);
        Template tpl = BeetlTemplateUtil.getByName("AllInOne.btl");
        tpl.binding("apiDocList", apiDocList);
        tpl.binding("errorCodeList", errorCodeList);
        FileUtil.nioWriteFile((String)tpl.render(), (String)(outPath + FILE_SEPARATOR + "AllInOne.md"));
    }

    private static void buildErrorCodeDoc(List<ApiErrorCode> errorCodeList, String outPath) {
        if (CollectionUtil.isNotEmpty(errorCodeList)) {
            Template mapper = BeetlTemplateUtil.getByName("ErrorCodeList.btl");
            mapper.binding("list", errorCodeList);
            FileUtil.nioWriteFile((String)mapper.render(), (String)(outPath + FILE_SEPARATOR + "ErrorCodeList.md"));
        }
    }
}

