/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;

public class IpUtil {
    private static String serverIp;

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if ("0:0:0:0:0:0:0:1".equals(ip)) {
            ip = IpUtil.getServerIp();
        }
        return ip;
    }

    public static String getServerIp() {
        return serverIp;
    }

    static {
        InetAddress ia = null;
        try {
            ia = ia.getLocalHost();
            serverIp = ia.getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

