/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import com.power.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class CollectionUtil {
    public static <T> boolean isNotEmpty(Collection<T> c) {
        return c != null && c.size() != 0;
    }

    public static <T> boolean isEmpty(Collection<T> c) {
        return c == null || c.size() == 0;
    }

    public static <T> List<T> slice(List<T> source, int from, int to) {
        if (CollectionUtil.isEmpty(source)) {
            return null;
        }
        int size = source.size();
        if (to > size) {
            return CollectionUtil.slice(source.stream(), from, size).collect(Collectors.toList());
        }
        return CollectionUtil.slice(source.stream(), from, to).collect(Collectors.toList());
    }

    public static <T> Stream<T> slice(Stream<T> stream, int startIndex, int endIndex) {
        return stream.collect(Collectors.toList()).subList(startIndex, endIndex).stream();
    }

    public static <T> List<List<T>> partition(List<T> list, int size) {
        if (list != null && list.size() > 0) {
            return new ArrayList(IntStream.range(0, list.size()).boxed().collect(Collectors.groupingBy(e -> e / size, Collectors.mapping(e -> list.get((int)e), Collectors.toList()))).values());
        }
        throw new NullPointerException("List can't be null");
    }

    public static <T> List<T> asList(T ... a) {
        if (null != a) {
            return Arrays.asList(a);
        }
        return new ArrayList(0);
    }

    public static <T> List<T> mergeAndSwap(List<T> result1, List<T> result2) {
        if (CollectionUtil.isEmpty(result1) && CollectionUtil.isEmpty(result2)) {
            return new ArrayList(0);
        }
        if (CollectionUtil.isEmpty(result1) && CollectionUtil.isNotEmpty(result2)) {
            return result2;
        }
        if (CollectionUtil.isNotEmpty(result1) && CollectionUtil.isEmpty(result2)) {
            return result1;
        }
        int a = result1.size();
        int b = result2.size();
        int size = a + b;
        ArrayList<T> finalResult = new ArrayList<T>(size);
        if (a >= b) {
            for (int i = 0; i < size; ++i) {
                if (i > (b << 1) - 1) {
                    finalResult.add(result1.get(i - b));
                } else if ((i & 1) == 0 && i >> 1 < a) {
                    finalResult.add(result1.get(i >> 1));
                }
                if ((i & 1) != 1 || i - 1 >> 1 >= b) continue;
                finalResult.add(result2.get(i - 1 >> 1));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if ((i & 1) == 0 && i >> 1 < a) {
                    finalResult.add(result1.get(i >> 1));
                }
                if ((i & 1) == 1 && i >> 1 < a - 1) {
                    finalResult.add(result2.get(i - 1 >> 1));
                }
                if (i < (a << 1) - 1) continue;
                finalResult.add(result2.get(i - a));
            }
        }
        return finalResult;
    }

    public static List<Map<String, Object>> filterEmpty(List<Map<String, Object>> list, String ... exceptKeys) {
        ArrayList<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : list) {
            int a = map.size();
            int counter = 0;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                for (String str : exceptKeys) {
                    if (entry.getKey().equals(str)) continue;
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        if (!StringUtil.isEmpty(String.valueOf(value))) continue;
                        ++counter;
                        continue;
                    }
                    if (null != value) continue;
                    ++counter;
                }
            }
            if (counter >= a - exceptKeys.length) continue;
            tempList.add(map);
        }
        return tempList;
    }
}

