/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.core.kit;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.HmacAlgorithm;
import com.ijpay.core.XmlHelper;
import com.ijpay.core.enums.RequestMethodEnum;
import com.ijpay.core.kit.RsaKit;
import com.ijpay.core.model.CertificateModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class PayKit {
    public static String hmacSha256(String data, String key) {
        return SecureUtil.hmac((HmacAlgorithm)HmacAlgorithm.HmacSHA256, (String)key).digestHex(data);
    }

    public static String sha1(File dataFile) {
        return SecureUtil.sha1((File)dataFile);
    }

    public static String sha1(InputStream data) {
        return SecureUtil.sha1((InputStream)data);
    }

    public static String sha1(String data) {
        return SecureUtil.sha1((String)data);
    }

    public static String md5(String data) {
        return SecureUtil.md5((String)data);
    }

    public static String decryptData(String base64Data, String key) {
        return SecureUtil.aes((byte[])PayKit.md5(key).toLowerCase().getBytes()).decryptStr(base64Data);
    }

    public static String encryptData(String data, String key) {
        return SecureUtil.aes((byte[])PayKit.md5(key).toLowerCase().getBytes()).encryptBase64(data.getBytes());
    }

    public static String generateStr() {
        return IdUtil.fastSimpleUUID();
    }

    public static Snowflake getSnowflake(long workerId, long dataCenterId) {
        return IdUtil.getSnowflake((long)workerId, (long)dataCenterId);
    }

    public static String createLinkString(Map<String, String> params) {
        return PayKit.createLinkString(params, false);
    }

    public static String createLinkString(Map<String, String> params, boolean encode) {
        return PayKit.createLinkString(params, "&", encode);
    }

    public static String createLinkString(Map<String, String> params, String connStr, boolean encode) {
        return PayKit.createLinkString(params, connStr, encode, false);
    }

    public static String createLinkString(Map<String, String> params, String connStr, boolean encode, boolean quotes) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                if (quotes) {
                    content.append(key).append("=").append('\"').append(encode ? PayKit.urlEncode(value) : value).append('\"');
                    continue;
                }
                content.append(key).append("=").append(encode ? PayKit.urlEncode(value) : value);
                continue;
            }
            if (quotes) {
                content.append(key).append("=").append('\"').append(encode ? PayKit.urlEncode(value) : value).append('\"').append(connStr);
                continue;
            }
            content.append(key).append("=").append(encode ? PayKit.urlEncode(value) : value).append(connStr);
        }
        return content.toString();
    }

    public static String urlEncode(String src) {
        try {
            return URLEncoder.encode(src, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static StringBuffer forEachMap(Map<String, String> params, String prefix, String suffix) {
        StringBuffer xml = new StringBuffer();
        if (StrUtil.isNotEmpty((CharSequence)prefix)) {
            xml.append(prefix);
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StrUtil.isEmpty((CharSequence)value)) continue;
            xml.append("<").append(key).append(">");
            xml.append(entry.getValue());
            xml.append("</").append(key).append(">");
        }
        if (StrUtil.isNotEmpty((CharSequence)suffix)) {
            xml.append(suffix);
        }
        return xml;
    }

    public static String toXml(Map<String, String> params) {
        StringBuffer xml = PayKit.forEachMap(params, "<xml>", "</xml>");
        return xml.toString();
    }

    public static Map<String, String> xmlToMap(String xmlStr) {
        XmlHelper xmlHelper = XmlHelper.of(xmlStr);
        return xmlHelper.toMap();
    }

    public static String buildSignMessage(RequestMethodEnum method, String url, long timestamp, String nonceStr, String body) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(method.toString());
        arrayList.add(url);
        arrayList.add(String.valueOf(timestamp));
        arrayList.add(nonceStr);
        arrayList.add(body);
        return PayKit.buildSignMessage(arrayList);
    }

    public static String buildSignMessage(String timestamp, String nonceStr, String body) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(timestamp);
        arrayList.add(nonceStr);
        arrayList.add(body);
        return PayKit.buildSignMessage(arrayList);
    }

    public static String buildSignMessage(ArrayList<String> signMessage) {
        if (signMessage == null || signMessage.size() <= 0) {
            return null;
        }
        StringBuilder sbf = new StringBuilder();
        for (String str : signMessage) {
            sbf.append(str).append("\n");
        }
        return sbf.toString();
    }

    public static String createSign(ArrayList<String> signMessage, String keyPath) throws Exception {
        return PayKit.createSign(PayKit.buildSignMessage(signMessage), keyPath);
    }

    public static String createSign(ArrayList<String> signMessage, PrivateKey privateKey) throws Exception {
        return PayKit.createSign(PayKit.buildSignMessage(signMessage), privateKey);
    }

    public static String createSign(String signMessage, String keyPath) throws Exception {
        if (StrUtil.isEmpty((CharSequence)signMessage)) {
            return null;
        }
        PrivateKey privateKey = PayKit.getPrivateKey(keyPath);
        return RsaKit.encryptByPrivateKey(signMessage, privateKey);
    }

    public static String createSign(String signMessage, PrivateKey privateKey) throws Exception {
        if (StrUtil.isEmpty((CharSequence)signMessage)) {
            return null;
        }
        return RsaKit.encryptByPrivateKey(signMessage, privateKey);
    }

    public static String getAuthorization(String mchId, String serialNo, String nonceStr, String timestamp, String signature, String authType) {
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("mchid", mchId);
        params.put("serial_no", serialNo);
        params.put("nonce_str", nonceStr);
        params.put("timestamp", timestamp);
        params.put("signature", signature);
        return authType.concat(" ").concat(PayKit.createLinkString(params, ",", false, true));
    }

    public static String getPrivateKeyStr(String keyPath) throws Exception {
        return RsaKit.getPrivateKeyStr(PayKit.getPrivateKey(keyPath));
    }

    public static PrivateKey getPrivateKey(String keyPath) throws Exception {
        String originalKey = PayKit.getCertFileContent(keyPath);
        if (StrUtil.isEmpty((CharSequence)originalKey)) {
            throw new RuntimeException("\u5546\u6237\u79c1\u94a5\u8bc1\u4e66\u83b7\u53d6\u5931\u8d25");
        }
        return PayKit.getPrivateKeyByKeyContent(originalKey);
    }

    public static PrivateKey getPrivateKeyByKeyContent(String originalKey) throws Exception {
        String privateKey = originalKey.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
        return RsaKit.loadPrivateKey(privateKey);
    }

    public static X509Certificate getCertificate(InputStream inputStream) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
            cert.checkValidity();
            return cert;
        }
        catch (CertificateExpiredException e) {
            throw new RuntimeException("\u8bc1\u4e66\u5df2\u8fc7\u671f", e);
        }
        catch (CertificateNotYetValidException e) {
            throw new RuntimeException("\u8bc1\u4e66\u5c1a\u672a\u751f\u6548", e);
        }
        catch (CertificateException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
    }

    public static X509Certificate getCertificate(String path) {
        InputStream inputStream;
        if (StrUtil.isEmpty((CharSequence)path)) {
            return null;
        }
        try {
            inputStream = PayKit.getCertFileInputStream(path);
        }
        catch (IOException e) {
            throw new RuntimeException("\u8bf7\u68c0\u67e5\u8bc1\u4e66\u8def\u5f84\u662f\u5426\u6b63\u786e", e);
        }
        return PayKit.getCertificate(inputStream);
    }

    public static CertificateModel getCertificateInfo(X509Certificate certificate) {
        if (null == certificate) {
            return null;
        }
        CertificateModel model = new CertificateModel();
        model.setItself(certificate);
        model.setIssuerDn(certificate.getIssuerDN());
        model.setSubjectDn(certificate.getSubjectDN());
        model.setVersion(certificate.getVersion());
        model.setNotBefore(certificate.getNotBefore());
        model.setNotAfter(certificate.getNotAfter());
        model.setSerialNumber(certificate.getSerialNumber().toString(16));
        return model;
    }

    public static CertificateModel getCertificateInfo(String path) {
        X509Certificate certificate = PayKit.getCertificate(path);
        return PayKit.getCertificateInfo(certificate);
    }

    public static boolean checkCertificateIsValid(CertificateModel model, String mchId, int offsetDay) {
        DateTime now;
        Principal subjectDn;
        if (null == model) {
            return false;
        }
        Date notAfter = model.getNotAfter();
        if (null == notAfter) {
            return false;
        }
        Principal issuerDn = model.getIssuerDn();
        if (null == issuerDn || !issuerDn.getName().contains("CN=Tenpay.com Root CA")) {
            return false;
        }
        if (StrUtil.isNotEmpty((CharSequence)mchId) && (null == (subjectDn = model.getSubjectDn()) || !subjectDn.getName().contains("CN=".concat(mchId.trim())))) {
            return false;
        }
        String serialNumber = model.getSerialNumber();
        if (StrUtil.isEmpty((CharSequence)serialNumber) || serialNumber.length() != 40) {
            return false;
        }
        DateTime dateTime = DateUtil.offsetDay((Date)notAfter, (int)offsetDay);
        int compare = DateUtil.compare((Date)dateTime, (Date)(now = DateUtil.date()));
        return compare >= 0;
    }

    public static boolean checkCertificateIsValid(X509Certificate certificate, String mchId, int offsetDay) {
        if (null == certificate) {
            return false;
        }
        CertificateModel model = PayKit.getCertificateInfo(certificate);
        return PayKit.checkCertificateIsValid(model, mchId, offsetDay);
    }

    public static boolean checkCertificateIsValid(String path, String mchId, int offsetDay) {
        return PayKit.checkCertificateIsValid(PayKit.getCertificateInfo(path), mchId, offsetDay);
    }

    public static String rsaEncryptOAEP(String data, X509Certificate certificate) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, certificate.getPublicKey());
            byte[] dataByte = data.getBytes(StandardCharsets.UTF_8);
            byte[] cipherData = cipher.doFinal(dataByte);
            return Base64.encode((byte[])cipherData);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA v1.5/OAEP", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalBlockSizeException("\u52a0\u5bc6\u539f\u4e32\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7214\u5b57\u8282");
        }
    }

    public static String rsaDecryptOAEP(String cipherText, PrivateKey privateKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(2, privateKey);
            byte[] data = Base64.decode((CharSequence)cipherText);
            return new String(cipher.doFinal(data), StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA v1.5/OAEP", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u79c1\u94a5", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new BadPaddingException("\u89e3\u5bc6\u5931\u8d25");
        }
    }

    public static InputStream getFileToStream(String classPath) {
        ClassPathResource resource = new ClassPathResource(classPath);
        return resource.getStream();
    }

    public static String getAbsolutePath(String classPath) {
        return new ClassPathResource(classPath).getAbsolutePath();
    }

    public static InputStream getCertFileInputStream(String path) throws IOException {
        if (StrUtil.isBlank((CharSequence)path)) {
            return null;
        }
        File file = new File(path);
        if (file.exists()) {
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        return PayKit.getFileToStream(path);
    }

    public static String getCertFileContent(String path) {
        if (StrUtil.isBlank((CharSequence)path)) {
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            path = PayKit.getAbsolutePath(path);
        }
        return FileUtil.readUtf8String((String)path);
    }
}

