/*
 * Decompiled with CFR 0.152.
 */
package com.github.felfert.sslutils;

import com.github.felfert.sslutils.TrustAllManager;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrustAllSSLSocketFactory {
    static final Logger LOGGER = LoggerFactory.getLogger(TrustAllSSLSocketFactory.class);
    private final SSLSocketFactory ssf;

    public TrustAllSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, new TrustManager[]{new TrustAllManager()}, new SecureRandom());
        this.ssf = ctx.getSocketFactory();
    }

    public Socket createSocket(String host, int port) throws IOException {
        LOGGER.warn("Using insecure TrustAllSSLSocketFactory!");
        return this.ssf.createSocket(host, port);
    }

    public Socket createSocket() throws IOException {
        LOGGER.warn("Using insecure TrustAllSSLSocketFactory!");
        return this.ssf.createSocket();
    }

    public SSLSocketFactory getRealSSLSocketFactory() {
        LOGGER.warn("Using insecure TrustAllSSLSocketFactory!");
        return this.ssf;
    }

    public static Object getDefault() throws NoSuchAlgorithmException, KeyManagementException {
        return new TrustAllSSLSocketFactory();
    }
}

