/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.github.dreamhead.moco.HttpHeader;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoEventAction;
import com.github.dreamhead.moco.parser.model.BaseActionSetting;
import com.github.dreamhead.moco.parser.model.TextContainer;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.Resource;
import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Optional;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public final class PostSetting
extends BaseActionSetting {
    private TextContainer url;
    private Map<String, TextContainer> headers;
    private TextContainer content;
    private Object json;

    public MocoEventAction createAction() {
        Optional<ContentResource> postContent = this.postContent();
        if (postContent.isPresent()) {
            ContentResource content = postContent.get();
            return this.doCreateAction(content);
        }
        throw new IllegalArgumentException("content or json should be setup for post event");
    }

    private MocoEventAction doCreateAction(ContentResource content) {
        ContentResource url = this.url.asResource();
        return Moco.post((Resource)url, (ContentResource)content, (HttpHeader[])this.asHeaders(this.headers));
    }

    private Optional<ContentResource> postContent() {
        if (this.content != null) {
            return Optional.of(this.content.asResource());
        }
        if (this.json != null) {
            return Optional.of(Moco.json((Object)this.json));
        }
        return Optional.empty();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("url", (Object)this.url).add("headers", this.headers).add("content", (Object)this.content).add("json", this.json).toString();
    }
}

